/*
 * CreateNodesGia.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesGia(Nodes** pnodes, IoModel* iomodel){

	/*Recover pointer: */
	Nodes* nodes=*pnodes;

	/*Create nodes if they do not exist yet*/
	if(!nodes) nodes = new Nodes();

	/*First fetch data: */
	iomodel->FetchData(1,MaskVertexonwaterEnum);

	/*First fetch data: */
	for(int i=0;i<iomodel->numberofvertices;i++){
		if(iomodel->my_vertices[i]){

			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,GiaAnalysisEnum));

		}
	}

	/*Clean fetched data: */
	iomodel->DeleteData(1,MaskVertexonwaterEnum);

	/*Assign output pointer: */
	*pnodes=nodes;
}
