/*
 * CreateNodesBalancethickness.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesBalancethickness(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	int  i,j;
	int  node_id;
	int  vertex_id;
	int  io_index;
	int  stabilization;
	bool *my_nodes=NULL;

	/*Fetch parameters: */
	iomodel->Constant(&stabilization,BalancethicknessStabilizationEnum);

	/*Recover pointer: */
	Nodes* nodes=*pnodes;

	/*Create nodes if they do not exist yet*/
	if(!nodes) nodes = new Nodes();

	/*Check in 3d*/
	if(stabilization==3 && iomodel->dim==3) _error_("DG 3d not implemented yet");

	/*First fetch data: */
	iomodel->FetchData(6,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);

	if(stabilization!=3){

		/*Build Nodes dataset (Continuous Galerkin)*/
		for (i=0;i<iomodel->numberofvertices;i++){
			if(iomodel->my_vertices[i]){

				/*Add node to nodes dataset: */
				nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,BalancethicknessAnalysisEnum));

			}
		}
	}
	else{

		/*Build Nodes dataset -> 3 for each element (Discontinuous Galerkin)*/
		NodesPartitioning(&my_nodes,iomodel->my_elements,iomodel->my_vertices,iomodel,false);
		for (i=0;i<iomodel->numberofelements;i++){
			for (j=0;j<3;j++){

				if(my_nodes[3*i+j]){ 

					//Get index of the vertex on which the current node is located
					vertex_id=iomodel->elements[3*i+j]; //(Matlab indexing)
					io_index=vertex_id-1;               //(C indexing)
					_assert_(vertex_id>0 && vertex_id<=iomodel->numberofvertices);

					//Compute Node id
					node_id=iomodel->nodecounter+3*i+j+1;

					/*Add node to nodes dataset: */
					nodes->AddObject(new Node(node_id,node_id-1,vertex_id,io_index,iomodel,BalancethicknessAnalysisEnum));

				}
			}
		}
	}

	/*Clean fetched data: */
	iomodel->DeleteData(6,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);
	xDelete<bool>(my_nodes);

	/*Assign output pointer: */
	*pnodes=nodes;
}
