%FLOWEQUATION class definition
%
%   Usage:
%      flowequation=flowequation();

classdef flowequation
	properties (SetAccess=public) 
		ismacayealpattyn     = 0;
		ishutter             = 0;
		isl1l2               = 0;
		isstokes             = 0;
		fe_stokes            = 0;
		fe_ssa               = 0;
		vertex_equation      = NaN;
		element_equation     = NaN;
		bordermacayeal       = NaN;
		borderpattyn         = NaN;
		borderstokes         = NaN;
	end
	methods
		function obj = flowequation(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			if ismember(DiagnosticHorizAnalysisEnum(),analyses),

				md = checkfield(md,'flowequation.ismacayealpattyn','numel',[1],'values',[0 1]);
				md = checkfield(md,'flowequation.ishutter','numel',[1],'values',[0 1]);
				md = checkfield(md,'flowequation.isl1l2','numel',[1],'values',[0 1]);
				md = checkfield(md,'flowequation.isstokes','numel',[1],'values',[0 1]);
				md = checkfield(md,'flowequation.bordermacayeal','size',[md.mesh.numberofvertices 1],'values',[0 1]);
				md = checkfield(md,'flowequation.borderpattyn','size',[md.mesh.numberofvertices 1],'values',[0 1]);
				md = checkfield(md,'flowequation.borderstokes','size',[md.mesh.numberofvertices 1],'values',[0 1]);
				if (md.mesh.dimension==2),
					md = checkfield(md,'flowequation.vertex_equation','size',[md.mesh.numberofvertices 1],'values',[1:2]);
					md = checkfield(md,'flowequation.element_equation','size',[md.mesh.numberofelements 1],'values',[1:2]);
				else
					md = checkfield(md,'flowequation.vertex_equation','size',[md.mesh.numberofvertices 1],'values',[0:8]);
					md = checkfield(md,'flowequation.element_equation','size',[md.mesh.numberofelements 1],'values',[0:8]);
				end
				if ~(obj.ismacayealpattyn || obj.ishutter || obj.isstokes || obj.isl1l2),
					md = checkmessage(md,['no element types set for this model. At least one of ismacayealpattyn, ishutter or isstokes need to be =1']);
				end
			end
			if ismember(DiagnosticHutterAnalysisEnum(),analyses),
				if any(obj.element_equation==1),
					if(obj.element_equation & md.mask.elementonfloatingice),
						disp(sprintf('\n !!! Warning: Hutter''s model is not consistent on ice shelves !!!\n'));
					end
				end
			end

		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   flow equation parameters:'));

			fielddisplay(obj,'ismacayealpattyn','is the macayeal or pattyn approximation used ?');
			fielddisplay(obj,'ishutter','is the shallow ice approximation used ?');
			fielddisplay(obj,'isl1l2','is the l1l2 approximation used ?');
			fielddisplay(obj,'isstokes','are the Full-Stokes equations used ?');
			fielddisplay(obj,'fe_ssa','Finite Element for SSA   0: Lagrange P1 (linear), 1: Lagrange P2 (quadratic)');
			fielddisplay(obj,'vertex_equation','flow equation for each vertex');
			fielddisplay(obj,'element_equation','flow equation for each element');
			fielddisplay(obj,'bordermacayeal','vertices on MacAyeal''s border (for tiling)');
			fielddisplay(obj,'borderpattyn','vertices on Pattyn''s border (for tiling)');
			fielddisplay(obj,'borderstokes','vertices on Stokes'' border (for tiling)');

		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','ismacayealpattyn','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','ishutter','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','isl1l2','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','isstokes','format','Boolean');
			WriteData(fid,'object',obj,'fieldname','fe_stokes','format','Integer');
			WriteData(fid,'object',obj,'fieldname','fe_ssa','format','Integer');
			WriteData(fid,'object',obj,'fieldname','bordermacayeal','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','borderpattyn','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','borderstokes','format','DoubleMat','mattype',1);
			%convert approximations to enums
			data=obj.vertex_equation;
			pos=find(data==0); data(pos,end)=NoneApproximationEnum();
			pos=find(data==1); data(pos,end)=HutterApproximationEnum();
			pos=find(data==2); data(pos,end)=MacAyealApproximationEnum();
			pos=find(data==3); data(pos,end)=PattynApproximationEnum();
			pos=find(data==4); data(pos,end)=StokesApproximationEnum();
			pos=find(data==5); data(pos,end)=MacAyealPattynApproximationEnum();
			pos=find(data==6); data(pos,end)=MacAyealStokesApproximationEnum();
			pos=find(data==7); data(pos,end)=PattynStokesApproximationEnum();
			pos=find(data==8); data(pos,end)=L1L2ApproximationEnum();
			WriteData(fid,'data',data,'enum',FlowequationVertexEquationEnum(),'format','DoubleMat','mattype',1);
			data=obj.element_equation;
			pos=find(data==0); data(pos,end)=NoneApproximationEnum();
			pos=find(data==1); data(pos,end)=HutterApproximationEnum();
			pos=find(data==2); data(pos,end)=MacAyealApproximationEnum();
			pos=find(data==3); data(pos,end)=PattynApproximationEnum();
			pos=find(data==4); data(pos,end)=StokesApproximationEnum();
			pos=find(data==5); data(pos,end)=MacAyealPattynApproximationEnum();
			pos=find(data==6); data(pos,end)=MacAyealStokesApproximationEnum();
			pos=find(data==7); data(pos,end)=PattynStokesApproximationEnum();
			pos=find(data==8); data(pos,end)=L1L2ApproximationEnum();
			WriteData(fid,'data',data,'enum',FlowequationElementEquationEnum(),'format','DoubleMat','mattype',2);
		end % }}}
	end
end
