/*! \file CreateLoadsHydrologyDCInefficient.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateLoadsHydrologyDCInefficient(Loads** ploads, IoModel* iomodel){

	/*Intermediary*/
	int hydrology_model;
	int dim;   

	/*Recover pointer: */
	Loads* loads=*ploads;

	/*Fetch parameters: */
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);
	iomodel->Constant(&dim,MeshDimensionEnum);
	iomodel->FetchData(1,MeshVertexonbedEnum);

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads();

	if(hydrology_model!=HydrologydcEnum){
		*ploads=loads;
		return;
	}

	//create penalties for nodes: no node can have a temperature over the melting point
	CreateSingleNodeToElementConnectivity(iomodel);
	for(int i=0;i<iomodel->numberofvertices;i++){
		if (!dim==3){
			/*keep only this partition's nodes:*/
			if((iomodel->my_vertices[i]==1)){
				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,HydrologyDCInefficientAnalysisEnum));
			}
		}
		else if(reCast<int>(iomodel->Data(MeshVertexonbedEnum)[i])){
			if((iomodel->my_vertices[i]==1)){
				loads->AddObject(new Pengrid(iomodel->loadcounter+i+1,i,iomodel,HydrologyDCInefficientAnalysisEnum));
			}	
		}
	}
	/*Assign output pointer: */
	*ploads=loads;
	iomodel->DeleteData(1,MeshVertexonbedEnum);
}
