/*
 * CreateNodesDiagnosticHoriz.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesDiagnosticHoriz(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	bool   continuous_galerkin=true;
	bool   isstokes,isl1l2,ismacayealpattyn;

	/*Fetch parameters: */
	iomodel->Constant(&isstokes,FlowequationIsstokesEnum);
	iomodel->Constant(&isl1l2,FlowequationIsl1l2Enum);
	iomodel->Constant(&ismacayealpattyn,FlowequationIsmacayealpattynEnum);

	/*Recover pointer: */
	Nodes* nodes=*pnodes;

	/*First create nodes*/
	if(!nodes) nodes = new Nodes();

	/*Now, is the flag macayaealpattyn on? otherwise, do nothing: */
	if(!ismacayealpattyn & !isstokes & !isl1l2){
		*pnodes=nodes;
		return;
	}

	/*Continuous Galerkin partition of nodes: */
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements,iomodel->my_vertices,iomodel,continuous_galerkin);

	/*Create nodes: */
	iomodel->FetchData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBordermacayealEnum,FlowequationBorderstokesEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);

	for(int i=0;i<iomodel->numberofvertices;i++){

		if(iomodel->my_vertices[i]){

			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,DiagnosticHorizAnalysisEnum));
		}
	}

	if(false){

		/*Quadratic element*/
		CreateEdges(iomodel);
		int  element1,element2;
		bool my_edge;

		for(int i=0;i<iomodel->numberofedges;i++){

			/*Get left and right elements*/
			element1=iomodel->edges[4*i+2]-1; //edges are [node1 node2 elem1 elem2]
			element2=iomodel->edges[4*i+3]-1; //edges are [node1 node2 elem1 elem2]

			/*Check whether we should include this edge (element2 is -2 for boundary edges)*/
			my_edge = iomodel->my_elements[element1];
			if(!my_edge && element2>=0){
				my_edge = iomodel->my_elements[element2];
			}

			/*Add node on edge*/
			if(my_edge){
				nodes->AddObject(new Node(iomodel->nodecounter+iomodel->numberofvertices+i+1,iomodel->numberofvertices+i,iomodel->numberofvertices+i+1,i,iomodel,DiagnosticHorizAnalysisEnum));
			}
		}
	}

	/*Clean fetched data: */
	iomodel->DeleteData(9,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,FlowequationBordermacayealEnum,FlowequationBorderstokesEnum,
				MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,MaskVertexonwaterEnum,FlowequationVertexEquationEnum,DiagnosticReferentialEnum);

	/*Assign output pointer: */
	*pnodes=nodes;
}
