/*!\file:  CreateElementToEdgeConnectivity.cpp
 * \brief: create connectivity tables from index
 */ 

#include "../../classes/classes.h"
#include "../../shared/shared.h"
#include "./ModelProcessorx.h"

void CreateElementToEdgeConnectivity(IoModel* iomodel){

	/*Intermediaries*/
	int v1,v2,v3,e1,e2;

	/*If connectivity is already present, exit*/
	if(iomodel->elementtoedgeconnectivity) return;

	/*Check Iomodel properties*/
	if(iomodel->dim!=2)             _error_("only 2d model are supported");
	if(iomodel->numberofvertices<3) _error_("not enough elements in mesh");
	_assert_(iomodel->elements);

	/*First, we need to have edges*/
	CreateEdges(iomodel);
	_assert_(iomodel->numberofedges>2);

	/*Initialize intermediaries*/
	int*  element_edge_connectivity = xNew<int>(iomodel->numberofelements*3);   /*edge1   edge2   edge3*/


	/*Go through all edges and create connectivity table*/
	for(int i=0;i<iomodel->numberofedges;i++){

		/*Get the two vertices of current edge*/
		v1 = iomodel->edges[i*4+0]; _assert_(v1>=0 && v1<iomodel->numberofvertices);
		v2 = iomodel->edges[i*4+1]; _assert_(v2>=0 && v2<iomodel->numberofvertices);
		e1 = iomodel->edges[i*4+2]; _assert_(e1>=0 && e1<iomodel->numberofelements);
		e2 = iomodel->edges[i*4+3]; _assert_(e2>=0 && e2<iomodel->numberofelements);

		/*Process element by element*/
		for(int j=0;j<3;j++){
			v3 = iomodel->elements[e1*3+j];
			if(v1!=v3 && v2!=v3){
				element_edge_connectivity[e1*3+j]=i;
				break;
			}
		}
		for(int j=0;j<3;j++){
			v3 = iomodel->elements[e2*3+j];
			if(v1!=v3 && v2!=v3){
				element_edge_connectivity[e2*3+j]=i;
				break;
			}
		}
	}

	/*Assign output pointers*/
	iomodel->elementtoedgeconnectivity = element_edge_connectivity;
}
