/*!\file:  ProcessMesh2d.cpp
 * \brief: create connectivity tables from index
 */ 

#include "../../shared/shared.h"

void ProcessMesh2d(int** pedges,int* pnumberofedges,int** pelement_edge_connectivity,int* index,int numberofelements,int numberofvertices){

	/*If mesh already processed, return*/
	if(*pedges) return;

	/*Intermediaries*/
	bool exist;
	int  i,j,v1,v2,v3;
	int  maxnbe,nbe;

	/*Checks in debugging mode*/
	_assert_(index);

	/*Maximum number of edges*/
	maxnbe = 3*numberofelements;

	/*Initialize intermediaries*/
	int*  edgestemp = xNew<int>(maxnbe*4); /*vertex1 vertex2 element1 element2*/
	bool* exchange  = xNewZeroInit<bool>(maxnbe);  
	int*  element_edge_connectivity = xNew<int>(numberofelements*3);   /*edge1   edge2   edge3*/
	for(i=0;i<maxnbe;i++) edgestemp[i*4+3]=-1;

	/*Initialize chain*/
	int* head_minv = xNew<int>(numberofvertices);
	int* next_edge = xNew<int>(maxnbe);
	for(i=0;i<numberofvertices;i++) head_minv[i]=-1;

	/*Initialize number of edges*/
	nbe = 0;

	for(i=0;i<numberofelements;i++){
		for(j=0;j<3;j++){

			/*Get the two indices of the edge number j of the ith triangle*/
			v1 = index[i*3+j];
			if(j==2)
			 v2 = index[i*3+0];
			else
			 v2 = index[i*3+j+1];

			/*v1 and v2 must be sorted*/
			if(v2<v1){
				v3=v2; v2=v1; v1=v3;
			}

			/*This edge a priori has not been processed yet*/
			exist = false;

			/*Go through all processed edges connected to v1 and check whether we have seen this edge yet*/
			_assert_(v1>=0 & v1<numberofvertices);
			for(int e=head_minv[v1]; e!=-1; e=next_edge[e]){
				if(edgestemp[e*4+1]==v2){
					exist = true;
					edgestemp[e*4+3]=i+1;
					element_edge_connectivity[i*3+j]=e;
					break;
				}
			}

			/*If this edge is new, add it to the lists*/
			if(!exist){
				_assert_(nbe<maxnbe);

				/*Update edges and element_edge_connectivity*/
				edgestemp[nbe*4+0] = v1;
				edgestemp[nbe*4+1] = v2;
				edgestemp[nbe*4+2] = i+1;
				element_edge_connectivity[i*3+j]=nbe;
				if(v1!=index[i*3+j]) exchange[nbe]=true;

				/*Update chain*/
				next_edge[nbe] = head_minv[v1];
				head_minv[v1]  = nbe;

				/*Increase number of edges*/
				nbe++;
			}
		}
	}

	/*Clean up*/
	xDelete<int>(head_minv);
	xDelete<int>(next_edge);

	/*Create final edges*/
	int* edges = xNew<int>(nbe*4); /*vertex1 vertex2 element1 element2*/
	for(int i=0;i<nbe;i++){
		if(exchange[i]){
			edges[i*4+0]=edgestemp[i*4+1];
			edges[i*4+1]=edgestemp[i*4+0];
		}
		else{
			edges[i*4+0]=edgestemp[i*4+0];
			edges[i*4+1]=edgestemp[i*4+1];
		}
		edges[i*4+2]=edgestemp[i*4+2];
		edges[i*4+3]=edgestemp[i*4+3];
	}
	xDelete<int>(edgestemp);
	xDelete<bool>(exchange);

	/*Assign output pointers*/
	if(pedges) *pedges = edges;
	else xDelete<int>(edges);

	if(pnumberofedges) *pnumberofedges = nbe;

	if(pelement_edge_connectivity) *pelement_edge_connectivity = element_edge_connectivity;
	else xDelete<int>(element_edge_connectivity);
}
