/*! \file CreateLoadsBalancethickness.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateLoadsBalancethickness(Loads** ploads, IoModel* iomodel){

	/*Intermediary*/
	int element;
	int stabilization;

	/*Fetch parameters: */
	iomodel->Constant(&stabilization,BalancethicknessStabilizationEnum);

	/*Recover pointer: */
	Loads* loads=*ploads;

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads();

	/*Loads only in DG*/
	if (stabilization==3){

		/*Get edges and elements*/
		ProcessMesh2d(&iomodel->edges,&iomodel->numberofedges,NULL,iomodel->elements,iomodel->numberofelements,iomodel->numberofvertices);
		iomodel->FetchData(1,ThicknessEnum);

		/*First load data:*/
		for(int i=0;i<iomodel->numberofedges;i++){

			/*Get left and right elements*/
			element=iomodel->edges[4*i+2]-1; //edges are [node1 node2 elem1 elem2]

			/*Now, if this element is not in the partition, pass: */
			if(!iomodel->my_elements[element]) continue;

			/* Add load */
			loads->AddObject(new Numericalflux(iomodel->loadcounter+i+1,i,i,iomodel,BalancethicknessAnalysisEnum));
		}

		/*Free data: */
		iomodel->DeleteData(1,ThicknessEnum);
	}

	/*Assign output pointer: */
	*ploads=loads;
}
