/*
 * UpdateElementsTransient:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	UpdateElementsTransient(Elements* elements, Parameters* parameters,IoModel* iomodel,int analysis_counter,int analysis_type){

	bool        isgl;
	int         migration_style;
	IssmDouble  rho_ice,rho_water;
	IssmDouble *phi   = NULL;

	/*Fetch data needed*/
	iomodel->Constant(&isgl,TransientIsgroundinglineEnum);
	iomodel->Constant(&migration_style,GroundinglineMigrationEnum);

	if(isgl==1 && (migration_style==SubelementMigrationEnum || migration_style==SubelementMigration2Enum)){

		/*get parameters and constants: */
		iomodel->Constant(&rho_ice,MaterialsRhoIceEnum);
		iomodel->Constant(&rho_water,MaterialsRhoWaterEnum);
		iomodel->FetchData(2,ThicknessEnum,BathymetryEnum);

		/*Create phi vector */
		phi=xNew<IssmDouble>(iomodel->numberofvertices);
		for(int i=0;i<iomodel->numberofvertices;i++){
			if(iomodel->my_vertices[i]){
				phi[i] = iomodel->Data(ThicknessEnum)[i] + rho_water/rho_ice * iomodel->Data(BathymetryEnum)[i];
			}
		}

		/*Update elements: */
		for(int i=0;i<elements->Size();i++){
			Element* element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
			element->InputCreate(phi,element->Sid(),iomodel,iomodel->numberofvertices,1,1,GLlevelsetEnum,1);
		}

		/*Free ressources:*/
		iomodel->DeleteData(2,ThicknessEnum,BathymetryEnum);
		xDelete<IssmDouble>(phi);
	}
}
