/*
 * CreateNodesHydrologyShreve.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void	CreateNodesHydrologyShreve(Nodes** pnodes, IoModel* iomodel){

	/*Intermediary*/
	int  hydrology_model;
	bool continuous_galerkin=true;

	/*Fetch parameters: */
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);

	/*Recover pointer: */
	Nodes* nodes=*pnodes;

	/*Create nodes if they do not exist yet*/
	if(!nodes) nodes = new Nodes();

	/*Now, do we really want Shreve?*/
	if(hydrology_model!=HydrologyshreveEnum){
		*pnodes=nodes;
		return;
	}

	/*Continuous Galerkin partition of nodes: */
	NodesPartitioning(&iomodel->my_nodes,iomodel->my_elements,iomodel->my_vertices,iomodel,continuous_galerkin);

	/*Create nodes and vertices: */
	iomodel->FetchData(6,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);
	for(int i=0;i<iomodel->numberofvertices;i++){

		if(iomodel->my_vertices[i]){
			/*Add node to nodes dataset: */
			nodes->AddObject(new Node(iomodel->nodecounter+i+1,i,i+1,i,iomodel,HydrologyShreveAnalysisEnum));
		}
	}
	iomodel->DeleteData(6,MeshVertexonbedEnum,MeshVertexonsurfaceEnum,MaskVertexongroundediceEnum,MaskVertexonfloatingiceEnum,FlowequationVertexEquationEnum,MaskVertexonwaterEnum);

	/*Assign output pointer: */
	*pnodes=nodes;
}
