/*!\file: CreateParametersDakota.cpp
 * \brief general driver for creating parameters dataset
 */ 

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../../MeshPartitionx/MeshPartitionx.h"
#include "../ModelProcessorx.h"

void CreateParametersDakota(Parameters** pparameters,IoModel* iomodel,char* rootpath,int solution_type,int analysis_type){

	/*variable declarations: {{{*/
	int i;
	Parameters* parameters = NULL;

	int*     part=NULL;
	double*  dpart=NULL;

	char**  responsedescriptors=NULL;
	int     numresponsedescriptors;
	char**  variabledescriptors=NULL;
	int     numvariabledescriptors;
	char*   descriptor=NULL;
	double* dakota_parameter=NULL;

	//qmu files
	char* qmuinname=NULL;
	char* qmuerrname=NULL;
	char* qmuoutname=NULL;

	//descriptors:
	char tag[50];

	bool     dakota_analysis=false;
	char*    name=NULL;
	int      numberofresponses;
	int      nrows;
	int      ncols;

	/*}}}*/

	/*recover parameters : */
	parameters=*pparameters;

	/*recover parameters: */
	iomodel->Constant(&dakota_analysis,QmuIsdakotaEnum);

	if(dakota_analysis){

		iomodel->Constant(&name,MiscellaneousNameEnum);
		iomodel->Constant(&numberofresponses,QmuNumberofresponsesEnum);

		/*name of qmu input, error and output files:{{{*/
		qmuinname=xNew<char>((strlen(rootpath)+strlen(name)+strlen(".qmu.in")+1));
		sprintf(qmuinname,"%s%s%s",rootpath,name,".qmu.in");
		parameters->AddObject(new   StringParam(QmuInNameEnum,qmuinname));

		qmuoutname=xNew<char>((strlen(rootpath)+strlen(name)+strlen(".qmu.out")+1));
		sprintf(qmuoutname,"%s%s%s",rootpath,name,".qmu.out");
		parameters->AddObject(new   StringParam(QmuOutNameEnum,qmuoutname));

		qmuerrname=xNew<char>((strlen(rootpath)+strlen(name)+strlen(".qmu.err")+1));
		sprintf(qmuerrname,"%s%s%s",rootpath,name,".qmu.err");
		parameters->AddObject(new   StringParam(QmuErrNameEnum,qmuerrname));
		/*}}}*/
		/*Fetch variable descriptors: {{{*/
		iomodel->FetchData(&variabledescriptors,&numvariabledescriptors,QmuVariabledescriptorsEnum);

		/*Ok, we have all the variable descriptors. Build a parameter with it: */
		parameters->AddObject(new StringArrayParam(QmuVariabledescriptorsEnum,variabledescriptors,numvariabledescriptors));

		/*}}}*/
		/*Fetch response descriptors: {{{*/
		iomodel->FetchData(&responsedescriptors,&numresponsedescriptors,QmuResponsedescriptorsEnum);

		/*Ok, we have all the response descriptors. Build a parameter with it: */
		parameters->AddObject(new StringArrayParam(QmuResponsedescriptorsEnum,responsedescriptors,numresponsedescriptors));
		parameters->AddObject(new    IntParam(QmuNumberofresponsesEnum,numberofresponses));
		/*}}}*/
		/*Deal with partitioning: {{{*/
		/*partition vertices in iomodel->qmu_npart parts, unless a partition is already present: */

		parameters->AddObject(iomodel->CopyConstantObject(QmuNumberofpartitionsEnum));
		iomodel->FetchData(&dpart,NULL,NULL,QmuPartitionEnum);

		if(!dpart){

			/*Partition elements and vertices and nodes: */
			ElementsAndVerticesPartitioning(&iomodel->my_elements,&iomodel->my_vertices,iomodel);

			dpart=xNew<double>(iomodel->numberofvertices);
			for(i=0;i<iomodel->numberofvertices;i++)dpart[i]=iomodel->my_vertices[i];
		}
		parameters->AddObject(new DoubleVecParam(QmuPartitionEnum,dpart,iomodel->numberofvertices));
		/*}}}*/
		/*Deal with data needed because of qmu variables: {{{*/

		for(i=0;i<numvariabledescriptors;i++){

			if (strncmp(variabledescriptors[i],"scaled_",7)==0){
				/*Ok, we are dealing with a variable that is distributed over nodes. Recover the name of the variable (ex: scaled_Thickness): */
				sscanf(variabledescriptors[i],"scaled_%s",tag);

				/*Recover data: */
				iomodel->FetchData(&dakota_parameter,&nrows,&ncols,StringToEnumx(tag));

				/*Add to parameters: */
				if(nrows==iomodel->numberofvertices){
					parameters->AddObject(new DoubleMatParam(StringToEnumx(tag),dakota_parameter,nrows,ncols));
				}
				else{
					parameters->AddObject(new DoubleTransientMatParam(StringToEnumx(tag),dakota_parameter,nrows,ncols));
				}

				/*Free ressources:*/
				xDelete<double>(dakota_parameter);
			}
		}
		/*}}}*/
		/*Free data: {{{*/
		for(i=0;i<numresponsedescriptors;i++){
			descriptor=responsedescriptors[i];
			xDelete<char>(descriptor);
		}
		xDelete<char*>(responsedescriptors);

		for(i=0;i<numvariabledescriptors;i++){
			descriptor=variabledescriptors[i];
			xDelete<char>(descriptor);
		}
		xDelete<char*>(variabledescriptors);
		xDelete<int>(part);
		xDelete<double>(dpart);
		xDelete<char>(qmuinname);
		xDelete<char>(qmuerrname);
		xDelete<char>(qmuoutname);
		/*}}}*/
	} //if(dakota_analysis)

	/*Free data*/
	xDelete<char>(name);

	/*Assign output pointer: */
	*pparameters=parameters;
}
