/*! \file CreateLoadsBalancethickness.c:
 */

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateLoadsBalancethickness(Loads** ploads, IoModel* iomodel){

	/*Intermediary*/
	int element;
	int stabilization;
	int numberofedges;

	/*Fetch parameters: */
	iomodel->Constant(&stabilization,BalancethicknessStabilizationEnum);
	iomodel->Constant(&numberofedges,MeshNumberofedgesEnum);

	/*Recover pointer: */
	Loads* loads=*ploads;

	/*Create loads if they do not exist yet*/
	if(!loads) loads = new Loads();

	/*Loads only in DG*/
	if (stabilization==3){

		/*Get edges and elements*/
		iomodel->FetchData(2,MeshEdgesEnum,ThicknessEnum);

		/*First load data:*/
		for (int i=0;i<numberofedges;i++){

			/*Get left and right elements*/
			element=reCast<int,IssmDouble>(iomodel->Data(MeshEdgesEnum)[4*i+2])-1; //edges are [node1 node2 elem1 elem2]

			/*Now, if this element is not in the partition, pass: */
			if(!iomodel->my_elements[element]) continue;

			/* Add load */
			loads->AddObject(new Numericalflux(iomodel->loadcounter+i+1,i,iomodel,BalancethicknessAnalysisEnum));
		}

		/*Free data: */
		iomodel->DeleteData(2,MeshEdgesEnum,ThicknessEnum);
	}

	/*Assign output pointer: */
	*ploads=loads;
}
