/*!\file: CreateParametersHydrologyDCInefficient.cpp
 * \brief driver for creating parameters dataset, for control analysis.
 */ 

#include "../../../toolkits/toolkits.h"
#include "../../../classes/classes.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void CreateParametersHydrologyDCInefficient(Parameters** pparameters,IoModel* iomodel,int solution_type,int analysis_type){

	Parameters *parameters = NULL;
	int         hydrology_model;
	int         sedimentlimit_flag;
	int         transfer_flag;
	bool        isefficientlayer;
	IssmDouble  sedimentlimit;
	IssmDouble  penalty_factor;
	IssmDouble  leakagefactor;
	IssmDouble  rel_tol;

	/*Get parameters: */
	parameters=*pparameters;

	/*retrieve some parameters: */
	iomodel->Constant(&hydrology_model,HydrologyModelEnum);

	/*Now, do we really want DC?*/
	if(hydrology_model!=HydrologydcEnum){
		*pparameters=parameters;
		return;
	}

	iomodel->FetchData(&isefficientlayer,HydrologydcIsefficientlayerEnum);
	iomodel->FetchData(&sedimentlimit_flag,HydrologydcSedimentlimitFlagEnum);
	iomodel->FetchData(&transfer_flag,HydrologydcTransferFlagEnum);
	iomodel->FetchData(&penalty_factor,HydrologydcPenaltyFactorEnum);
	iomodel->FetchData(&rel_tol,HydrologydcRelTolEnum);

	if(sedimentlimit_flag==1){
		iomodel->FetchData(&sedimentlimit,HydrologydcSedimentlimitEnum);
		parameters->AddObject(new DoubleParam(HydrologydcSedimentlimitEnum,sedimentlimit));
	}

	if(transfer_flag==1){
		iomodel->FetchData(&leakagefactor,HydrologydcLeakageFactorEnum);
		parameters->AddObject(new DoubleParam(HydrologydcLeakageFactorEnum,leakagefactor));
	}

	parameters->AddObject(new DoubleParam(HydrologydcPenaltyFactorEnum,penalty_factor));
	parameters->AddObject(new IntParam(HydrologyModelEnum,hydrology_model));
	parameters->AddObject(new BoolParam(HydrologydcIsefficientlayerEnum,isefficientlayer));
	parameters->AddObject(new IntParam(HydrologydcSedimentlimitFlagEnum,sedimentlimit_flag));
	parameters->AddObject(new IntParam(HydrologydcTransferFlagEnum,transfer_flag));
	parameters->AddObject(new DoubleParam(HydrologydcRelTolEnum,rel_tol));

	/*Assign output pointer: */
	*pparameters=parameters;
}
