/*!\file Segment.h
 * \brief: header file for node object
 */

#ifndef _SEGMENT_H_
#define _SEGMENT_H_

/*Headers:*/
/*{{{*/
#include "../datastructures/datastructures.h"
#include "../shared/Numerics/constants.h"
/*}}}*/

template <class doubletype> 
class Segment: public Object{

	public:
		int        eid;
		doubletype x1;
		doubletype y1;
		doubletype x2;
		doubletype y2;

		/*Segment constructors, destructors :*/
		/*FUNCTION Segment() default constructor {{{*/
		Segment(){
			this->eid = UNDEF;
			this->x1  = UNDEF;
			this->y1  = UNDEF;
			this->x2  = UNDEF;
			this->y2  = UNDEF;
		}
		/*}}}*/
		/*FUNCTION Segment(int eid, doubletype x1,doubletype y1,doubletype x2, doubletype y2){{{*/
		Segment(int segment_eid, doubletype segment_x1,doubletype segment_y1,doubletype segment_x2, doubletype segment_y2){

			this->eid = segment_eid;
			this->x1  = segment_x1;
			this->y1  = segment_y1;
			this->x2  = segment_x2;
			this->y2  = segment_y2;

		}
		/*}}}*/
		/*FUNCTION ~Segment(){{{*/
		~Segment(){
		}
		/*}}}*/

		/*Object virtual functions definitions:*/
		/*FUNCTION Echo{{{*/
		void Echo(void){

			_printf_("Segment:\n");
			_printf_("   eid: " << eid << "\n");
			_printf_("   node 1: " << this->x1 << "|" << this->y1 << "\n");
			_printf_("   node 2: " << this->x2 << "|" << this->y2 << "\n");

		}
		/*}}}*/
		/*FUNCTION DeepEcho{{{*/
		void DeepEcho(void){
			this->Echo();
		}
		/*}}}*/
		/*FUNCTION Id{{{*/
		int    Id(void){ return eid; }
		/*}}}*/
		/*FUNCTION ObjectEnum{{{*/
		int ObjectEnum(void){

			return SegmentEnum;

		}
		/*}}}*/
		/*FUNCTION copy {{{*/
		Object* copy() {
			return new Segment(this->eid,this->x1,this->y1,this->x2,this->y2);
		}
		/*}}}*/

};

#endif  /* _SEGMENT_H_ */
