from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',180000.)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelfConstrained.py')
md.extrude(3,1.)
md=setflowequation(md,'macayeal','all')
md.cluster=generic('name',oshostname(),'np',1)
md.transient.isdiagnostic=False
md.transient.isprognostic=False
md.transient.isthermal=True
md.transient.isgroundingline=False
md.toolkits.DefaultAnalysis=issmsolver()
md.autodiff.isautodiff=True
md=solve(md,TransientSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Temperature','BasalforcingsMeltingRate']
field_tolerances=[1e-13,1e-13]
field_values=[\
	md.results.TransientSolution[0].Temperature,\
	md.results.TransientSolution[0].BasalforcingsMeltingRate,\
	]
