from model import *
from triangle import *
from setmask import *
from parameterize import *
from setflowequation import *
from EnumDefinitions import *
from solve import *
from MatlabFuncs import *

md=triangle(model(),'../Exp/Square.exp',180000.)
md=setmask(md,'all','')
md=parameterize(md,'../Par/SquareShelfConstrained.py')
md.extrude(3,2.)
md=setflowequation(md,'pattyn','all')
md.cluster=generic('name',oshostname(),'np',1)
md.diagnostic.requested_outputs=StressTensorEnum()
md.toolkits.DefaultAnalysis=issmsolver()
md.autodiff.isautodiff=True
md=solve(md,DiagnosticSolutionEnum())

#Fields and tolerances to track changes
field_names     =['Vx','Vy','Vz','Vel','Pressure',\
	'StressTensorxx','StressTensoryy','StressTensorzz','StressTensorxy','StressTensorxz','StressTensoryz']
field_tolerances=[1e-09,1e-09,1e-09,1e-09,1e-09,\
	1e-09,1e-09,1e-09,1e-09,1e-09,1e-09]
field_values=[\
	md.results.DiagnosticSolution.Vx,\
	md.results.DiagnosticSolution.Vy,\
	md.results.DiagnosticSolution.Vz,\
	md.results.DiagnosticSolution.Vel,\
	md.results.DiagnosticSolution.Pressure,\
	md.results.DiagnosticSolution.StressTensorxx,\
	md.results.DiagnosticSolution.StressTensoryy,\
	md.results.DiagnosticSolution.StressTensorzz,\
	md.results.DiagnosticSolution.StressTensorxy,\
	md.results.DiagnosticSolution.StressTensorxz,\
	md.results.DiagnosticSolution.StressTensoryz,\
	]
