import os
from collections import OrderedDict
from EnumDefinitions import *
from EnumToString import EnumToString

def process_solve_options(options):
	"""
	DEFAULT_SOLVE_OPTIONS - set up default options for solve phase
 
	   Usage:
	      options=process_solve_options(options)
 
	   See also: SOLVE
	"""

	outoptions=OrderedDict()

	#solution_type: check on this option, error out otherwise
	solution_type=options.getfieldvalue('solution_type')
	if solution_type not in (DiagnosticSolutionEnum(),PrognosticSolutionEnum(),ThermalSolutionEnum(),\
			SteadystateSolutionEnum(),TransientSolutionEnum(),EnthalpySolutionEnum(),\
			BalancethicknessSolutionEnum(),BedSlopeSolutionEnum(),SurfaceSlopeSolutionEnum(),\
			HydrologySolutionEnum(),FlaimSolutionEnum(),GiaSolutionEnum()):
		raise ValueError("process_solve_options error message: solution_type '%s' not supported yet!" % EnumToString(solution_type)[0])
	outoptions['solution_type']=solution_type

	outoptions['upload']=options.getfieldvalue('upload','off')
	outoptions['batch']=options.getfieldvalue('batch','no')
	outoptions['loadonly']=options.getfieldvalue('loadonly',False)
	outoptions['directory']=options.getfieldvalue('directory','')

	#  process qmu arguments
	outoptions['qmudir']=options.getfieldvalue('qmudir','qmu'+str(os.getpid()))
	outoptions['qmufile']=options.getfieldvalue('qmufile','qmu')    # qmufile cannot be changed unless ????script.sh is also changed
	outoptions['overwrite']=options.getfieldvalue('overwrite','n')
	outoptions['keep']=options.getfieldvalue('keep','n')
	outoptions['ivar']=options.getfieldvalue('ivar',1)
	outoptions['iresp']=options.getfieldvalue('iresp',1)
	outoptions['imethod']=options.getfieldvalue('imethod',1)
	outoptions['iparams']=options.getfieldvalue('iparams',1)
	outoptions['runmpi']=options.getfieldvalue('runmpi',False)

	#  process flaim arguments
	outoptions['fmdir']=options.getfieldvalue('fmdir','fm'+str(os.getpid()))
	outoptions['overwrite']=options.getfieldvalue('overwrite','n')
	outoptions['keep']=options.getfieldvalue('keep','y')
	outoptions['latsgn']=options.getfieldvalue('latsgn',0)
	outoptions['cmap']=options.getfieldvalue('cmap',[])

	return outoptions

