/*!\file InputDuplicatex
 * \brief: duplicte  an input inside the elements, onto another, and wipe it off.
 */

#include "./InputDuplicatex.h"
#include "../../shared/shared.h"
#include "../../classes/classes.h"
#include "../../toolkits/toolkits.h"

void InputDuplicatex(Elements* elements,Nodes* nodes,Vertices* vertices,Loads* loads,Materials* materials,Parameters* parameters,int original_enum, int new_enum){

	/*Go through elemnets, and ask to reinitialie the input: */
	int      i;
	for(i=0;i<elements->Size();i++){
		Element* element=dynamic_cast<Element*>(elements->GetObjectByOffset(i));
		element->InputDuplicate(original_enum,new_enum);
	}
	for(i=0;i<materials->Size();i++){
		Material* material=(Material*)materials->GetObjectByOffset(i);
		material->InputDuplicate(original_enum,new_enum);
	}

}
