/*!\file:  CorePointerFromSolutionEnum.cpp
 * \brief: return type of analyses, number of analyses and core solution function.
 */ 

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void CorePointerFromSolutionEnum(void (**psolutioncore)(FemModel*),Parameters* parameters,int solutiontype){

	/*output: */
	void (*solutioncore)(FemModel*)=NULL;

	switch(solutiontype){

		case DiagnosticSolutionEnum:
			#ifdef _HAVE_DIAGNOSTIC_
			solutioncore=&diagnostic_core;
			#else
			_error_("ISSM was not compiled with diagnostic capabilities. Exiting");
			#endif
			break;
		case SteadystateSolutionEnum:
			#ifdef _HAVE_STEADYSTATE_
			solutioncore=&steadystate_core;
			#else
			_error_("ISSM was not compiled with steady state capabilities. Exiting");
			#endif
			break;
		case ThermalSolutionEnum:
			#ifdef _HAVE_THERMAL_
			solutioncore=&thermal_core;
			#else
			_error_("ISSM was not compiled with thermal capabilities. Exiting");
			#endif
			break;
		case EnthalpySolutionEnum:
			#ifdef _HAVE_THERMAL_
			solutioncore=&enthalpy_core;
			#else
			_error_("ISSM was not compiled with thermal capabilities. Exiting");
			#endif
			break;
		case BalancethicknessSolutionEnum:
			#ifdef _HAVE_BALANCED_
			solutioncore=&balancethickness_core;
			#else
			_error_("ISSM was not compiled with balanced capabilities. Exiting");
			#endif
			break;
		case BalancethicknessSoftSolutionEnum:
			#ifdef _HAVE_BALANCED_
			solutioncore=&dummy_core;
			#else
			_error_("ISSM was not compiled with balanced capabilities. Exiting");
			#endif
			break;
		case HydrologySolutionEnum:
			#ifdef _HAVE_HYDROLOGY_
			solutioncore=&hydrology_core;
			#else
			_error_("ISSM was not compiled with hydrology capabilities. Exiting");
			#endif
			break;
		case SurfaceSlopeSolutionEnum:
			#ifdef _HAVE_SLOPE_
			solutioncore=&surfaceslope_core;
			#else
			_error_("ISSM was not compiled with slope capabilities. Exiting");
			#endif
			break;
		case BedSlopeSolutionEnum:
			#ifdef _HAVE_SLOPE_
			solutioncore=&bedslope_core;
			#else
			_error_("ISSM was not compiled with slope capabilities. Exiting");
			#endif
			break;
		case TransientSolutionEnum:
			#ifdef _HAVE_TRANSIENT_
			solutioncore=&transient_core;
			#else
			_error_("ISSM was not compiled with transient capabilities. Exiting");
			#endif
			break;
		case PrognosticSolutionEnum:
			#ifdef _HAVE_PROGNOSTIC_
			solutioncore=&prognostic_core;
			#else
			_error_("ISSM was not compiled with prognostic capabilities. Exiting");
			#endif
			break;

		case GiaSolutionEnum:
			#ifdef _HAVE_GIA_
			solutioncore=&gia_core;
			#else
			_error_("ISSM was not compiled with gia capabilities. Exiting");
			#endif
			break;

		default:
			_error_("solution type: " << EnumToStringx(solutiontype) << " not supported yet!");
			break;
	}

	/*Assign output pointer:*/
	_assert_(psolutioncore);
	*psolutioncore=solutioncore;

}
