#!/bin/bash
set -eu
#http://www.mcs.anl.gov/research/projects/tao/download/tao-2.2-pre1.tar.gz

#compatible with PETSc 3.4

#Some cleanup
rm -rf install tao-2.2-pre1
mkdir install

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/tao-2.2-pre1.tar.gz' 'tao-2.2-pre1.tar.gz'

#Untar 
tar -zxvf  tao-2.2-pre1.tar.gz

#move into place
mv tao-2.2-pre1/* install/
rm -rf tao-2.2-pre1

#compile
cd install
export TAO_DIR="$ISSM_DIR/externalpackages/tao/install/"
make
