/*\file KMLFileRead.c
 *\brief: KML file reader module.
 */
#include "./KMLFileRead.h"

void KMLFileReadUsage(void){/*{{{*/
	_printf0_("KMLFileRead - KML file reader module:\n");
	_printf0_("\n");
	_printf0_("   This module reads a KML file.\n");
	_printf0_("\n");
	_printf0_("   Usage:\n");
	_printf0_("      [ierror]=KMLFileRead(kmlfile,'param name',param,...);\n");
	_printf0_("\n");
	_printf0_("      kmlfile      file name of kml file to be read (char)\n");
	_printf0_("\n");
	_printf0_("      echo         echo command (char, optional, 'off'/'on')\n");
	_printf0_("      deepecho     deep echo command (char, optional, 'off'/'on')\n");
	_printf0_("      write        write command (char, optional, 'off'/'stdout'/kmlfile)\n");
	_printf0_("\n");
	_printf0_("      ierror       return code (non-zero for error)\n");
	_printf0_("\n");
	_printf0_("   Examples:\n");
	_printf0_("      [ierror]=KMLFileRead('file.kml','deepecho','on');\n");
	_printf0_("      [ierror]=KMLFileRead('filin.kml','echo','on','write','filout.kml');\n");
	_printf0_("\n");
}/*}}}*/
WRAPPER(KMLFileRead){

	int i,j,nnodes=0,verbose=1;
	KML_Object* kobj;

	/*input: */
	char*   name=NULL;
	char*   notes=NULL;
	const mxArray* notesi;
	mwIndex        nindex;
	int*    elem=NULL;
	int     melem=0,nelem=0;
	int*    nodecon=NULL;
	int     mncon=0,nncon=0;
	double* lat=NULL;
	int     mlat=0,nlat=0,llat=0;
	double* lng=NULL;
	int     mlng=0,nlng=0,llng=0;
	int     nparts=0;
	int*    part=NULL;
	int     mprt=0,nprt=0,lprt=0;
	double* data=NULL;
	int     mdata=0,ndata=0;
	double* cmap=NULL;
	int     mcmap=0,ncmap=0;
	char*   filnam=NULL;
	FILE*   fidi=NULL;
	FILE*   fido=NULL;
	Options* options=NULL;
	char*    echo    =NULL;
	char*    deepecho=NULL;
	char*    write   =NULL;

	/* output: */
	int     ierror=0;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	if (nlhs > NLHS) {
		KMLFileReadUsage(); _error_("KMLFileRead usage error");
	}
	if (nrhs < NRHS) {
		KMLFileReadUsage(); _error_("KMLFileRead usage error");
	}

	/*Input datasets: */
	FetchData(&filnam,FILENAME);
	FetchData(&options,NRHS,nrhs,prhs);
	FetchData(&options,NRHS,nrhs,prhs);

	options->Get(&echo    ,"echo"    ,(char*)"off");
	options->Get(&deepecho,"deepecho",(char*)"off");
	options->Get(&write   ,"write"   ,(char*)"off");

	/*some checks*/
	if (!strlen(filnam)) strcpy(filnam,"stdout");

	if (verbose) _printf_("Opening file \"" << filnam << "\".\n");
	fidi=fopen(filnam,"r");

	/* Run core computations: */
	if (verbose) _printf_("Calling core:\n");
	kobj=KMLFileReadx(fidi);

	if (verbose) _printf_("Closing file \"" << filnam << "\".\n");
	fclose(fidi);

	if (kobj){
		if (!strncmp(echo    ,"on",2) || !strncmp(echo    ,"y",1))
			kobj->Echo();
		if (!strncmp(deepecho,"on",2) || !strncmp(deepecho,"y",1))
			kobj->DeepEcho();
		if (strncmp(write,"off",3) && strncmp(write,"no",2)) {
			if (!strncmp(write,"on",2) || !strncmp(write,"yes",3) || !strncmp(write,"stdout",6)) {
				kobj->Write(stdout,"");
			}
			else {
				if (verbose) _printf_("Opening file \"" << write << "\".\n");
				fido=fopen(write,"w");
				kobj->Write(fido,"");
				if (verbose) _printf_("Closing file \"" << write << "\".\n");
				ierror=fclose(fido);
			}
		}
		delete kobj;
	}

	/*Write data: */
	WriteData(ERRORFLAG,ierror);

	/*Clean-up*/
	xDelete<char>(write);
	xDelete<char>(deepecho);
	xDelete<char>(echo);
	delete options;

	/*end module: */
	MODULEEND();
}
