/*!\file EdgeDetection.h
 * \brief: prototype for EdgeDetection module 
 */

#ifndef _EDGEDETECTION_H_
#define _EDGEDETECTION_H_

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
	#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

/*For python modules: needs to come before header files inclusion*/
#ifdef _HAVE_PYTHON_
#define PY_ARRAY_UNIQUE_SYMBOL PythonIOSymbol
#endif

/*Header files: */
#include "../bindings.h"
#include "../../c/main/globals.h"
#include "../../c/toolkits/toolkits.h"
#include "../../c/modules/modules.h"
#include "../../c/shared/shared.h"
#include "../../c/shared/io/io.h"
#include "../../c/shared/Enum/Enum.h"

#undef __FUNCT__ 
#define __FUNCT__  "EdgeDetection"

#ifdef _HAVE_MATLAB_MODULES_
/* serial input macros: */
#define IMAGE       prhs[0]
/* serial output macros: */
#define CONTOURS (mxArray**)&plhs[0]
#endif

#ifdef _HAVE_PYTHON_MODULES_
/* serial input macros: */
#define IMAGE       PyTuple_GetItem(args,0)
/* serial output macros: */
#define CONTOURS output,0
#endif

/* serial arg counts: */
#undef NLHS
#define NLHS  1
#undef NRHS
#define NRHS  1

#endif  /* _EDGEDETECTION_H_ */
