import os
from issmdir import *
from MatlabFuncs import *

def dakotaversion():
	"""
	DAKOTAVERSION - recover dakota version number, inside config.h file
 
	   Usage:
	      DAKOTA_VERSION=dakotaversion();
	"""

	#default
	DAKOTA_VERSION=''

	configfile=os.path.join(issmdir(),'config.h')
	if not os.path.exists(configfile):
		raise RuntimeError("File '%s' not found. ISSM has not been configured yet!" % configfile)

	#go through the file, and recover the line we want
	try:
		fid=open(configfile,'r')
	except IOError as e:
		raise IOerror("could not open file: '%s'" % configfile)

	for tline in fid:
		if strncmp(tline,'#define _DAKOTA_VERSION_',24):
			DAKOTA_VERSION=tline[25:].replace('"','').strip()
			break

	fid.close()

	return DAKOTA_VERSION

