%MASK class definition
%
%   Usage:
%      mask=mask();

classdef mask
	properties (SetAccess=public) 
		elementonfloatingice = NaN;
		elementongroundedice = NaN;
		elementonwater       = NaN;
		vertexonfloatingice  = NaN;
		vertexongroundedice  = NaN;
		vertexonwater        = NaN;
		vertexonrock        = NaN;
	end
	methods
		function obj = mask(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			md = checkfield(md,'mask.elementonfloatingice','size',[md.mesh.numberofelements 1],'values',[0 1]);
			md = checkfield(md,'mask.elementongroundedice','size',[md.mesh.numberofelements 1],'values',[0 1]);
			md = checkfield(md,'mask.elementonwater'      ,'size',[md.mesh.numberofelements 1],'values',[0 1]);
			md = checkfield(md,'mask.vertexonfloatingice','size',[md.mesh.numberofvertices 1],'values',[0 1]);
			md = checkfield(md,'mask.vertexongroundedice','size',[md.mesh.numberofvertices 1],'values',[0 1]);
			md = checkfield(md,'mask.vertexonwater'      ,'size',[md.mesh.numberofvertices 1],'values',[0 1]);
			%md = checkfield(md,'mask.vertexonrock'      ,'size',[md.mesh.numberofvertices 1],'values',[0 1]);
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   masks:'));

			fielddisplay(obj,'elementonfloatingice','element on floating ice flags list');
			fielddisplay(obj,'vertexonfloatingice','vertex on floating ice flags list');
			fielddisplay(obj,'elementongroundedice','element on grounded ice  list');
			fielddisplay(obj,'vertexongroundedice','vertex on grounded ice flags list');
			fielddisplay(obj,'elementonwater','element on rock flags list');
			fielddisplay(obj,'vertexonwater','vertex on water flags list');
			fielddisplay(obj,'vertexonrock','vertex on rock flags list');
		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','elementonfloatingice','format','BooleanMat','mattype',2);
			WriteData(fid,'object',obj,'fieldname','elementongroundedice','format','BooleanMat','mattype',2);
			WriteData(fid,'object',obj,'fieldname','elementonwater','format','BooleanMat','mattype',2);
			WriteData(fid,'object',obj,'fieldname','vertexonfloatingice','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','vertexongroundedice','format','DoubleMat','mattype',1);
			WriteData(fid,'object',obj,'fieldname','vertexonwater','format','DoubleMat','mattype',1);
		end % }}}
	end
end
