/*!\file FileParam.c
 * \brief: implementation of the FileParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "shared/shared.h"
/*}}}*/

/*FileParam constructors and destructor*/
/*FUNCTION FileParam::FileParam(){{{*/
FileParam::FileParam(){
	return;
}
/*}}}*/
/*FUNCTION FileParam::FileParam(int enum_type,FILE *value){{{*/
FileParam::FileParam(int in_enum_type,FILE* in_value){

	enum_type=in_enum_type;
	value=in_value;
}
/*}}}*/
/*FUNCTION FileParam::~FileParam(){{{*/
FileParam::~FileParam(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION FileParam::Echo {{{*/
void FileParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION FileParam::DeepEcho{{{*/
void FileParam::DeepEcho(void){

	_printf_("FileParam:\n");
	_printf_("   enum:  " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")\n");
	_printf_("   value: " << this->value << "\n");
}
/*}}}*/
/*FUNCTION FileParam::Id{{{*/
int    FileParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION FileParam::ObjectEnum{{{*/
int FileParam::ObjectEnum(void){

	return FileParamEnum;

}
/*}}}*/
/*FUNCTION FileParam::copy{{{*/
Object* FileParam::copy() {

	return new FileParam(this->enum_type,this->value);

}
/*}}}*/

/*FileParam virtual functions definitions: */
/*FUNCTION FileParam::GetParameterName{{{*/
void FileParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
