/*!\file:  adjointdiagnostic_core.cpp
 * \brief compute inverse method adjoint state
 */ 

#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void adjointdiagnostic_core(FemModel* femmodel){

	/*parameters: */
	bool isstokes;
	bool save_results;
	bool conserve_loads   = true;

	/*retrieve parameters:*/
	femmodel->parameters->FindParam(&isstokes,FlowequationIsstokesEnum);
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);

	/*Compute velocities*/
	if(VerboseSolution()) _printf0_("   computing velocities\n");
	femmodel->SetCurrentConfiguration(DiagnosticHorizAnalysisEnum);
	solutionsequence_nonlinear(femmodel,conserve_loads); 

	/*Call SurfaceAreax, because some it might be needed by PVector*/
	SurfaceAreax(NULL,femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);

	/*Compute adjoint*/
	if(VerboseSolution()) _printf0_("   computing adjoint\n");
	femmodel->SetCurrentConfiguration(DiagnosticHorizAnalysisEnum,AdjointHorizAnalysisEnum);
	solutionsequence_adjoint_linear(femmodel);

	/*Save results*/
	if(save_results){
		if(VerboseSolution()) _printf0_("   saving results\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointxEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointyEnum);
		if (isstokes){
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointzEnum);
			InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,AdjointpEnum);
		}
	}
}
