#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.2-p3 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-3.2-p3.tar.gz' 'petsc-3.2-p3.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.2-p3.tar.gz
mv petsc-3.2-p3/* src/
rm -rf petsc-3.2-p3

#configure
cd src
./config/configure.py \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--with-mpi-dir=/usr/lib/mpich \
	--with-clanguage=C++ \
	--PETSC_ARCH=linux-gnu-amd64 \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-debugging=0 \
	--with-shared-libraries=1 \
	--download-mumps=yes \
	--download-scalapack=yes \
	--download-blacs=yes \
	--download-blas=yes \
	--download-f-blas-lapack=yes \
	--download-plapack=yes \
	--download-parmetis=yes \
	--with-pic=1

#Compile petsc and install it
make
make install
