#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-3.1-p7 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-3.1-p7.tar.gz' 'petsc-3.1-p7.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-3.1-p7.tar.gz
mv petsc-3.1-p7/* src/
rm -rf petsc-3.1-p7

cd src
./config/configure.py  \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--PETSC_ARCH=cygwin-intel \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/src" \
	--with-debugging=0 \
	--download-c-blas-lapack=yes \
	--with-cc='win32fe cl' \
	--with-fc=0 \
	--with-cxx='win32fe cl' \
	--with-clanguage=cxx  \
	--with-mpi-include="/cygdrive/c/MPICH2/include" \
	--with-mpi-lib="/cygdrive/c/MPICH2/lib/mpi.lib"


#Compile petsc and install it
make
make install

patch ../install/include/petscfix.h ../configs/3.1/win7/petscfix.h.patch
