#!/bin/bash
#This bash script calls the nightlyrun.m matlab file to run our nightly test decks. 
#It then processes the results and sends an email to the Ice developpers.

#get configs
if [ $# -ne 1 ];
then
	source config/$1;
else
	echo "no config file specified. Exiting..."
fi

#create nightly run variables
export TODAY=`date | awk '{printf("%s-%s-%s",$2,$3,$6);}'`;
export HOST_NAME=`hostname`;
export ISSM_RELEASE="issm"

#create ISSM variables
export ISSM_DIR
export ISSM_ARCH

#Erase previous code and Fetch the new one
rm -rf trunk
svn checkout $REPOSITORY

#install ISSM

#1: modify some variables
cd $ISSM_DIR/etc

#modify MATLAB_PATH ( /usr/...   ->   \/usr\/...)
echo $MATLAB_PATH | sed 's/\//\\\//g' > MATLAB_PATH2
MATLAB_PATH2=`cat MATLAB_PATH2`
rm MATLAB_PATH2

#modify MATLAB_DIR in environment_variables.sh
cat environment_variables.sh | sed -e "s/C:\/MATLAB\/R2009a\//$MATLAB_PATH2/g" > environment_variables.sh.bak
mv environment_variables.sh.bak environment_variables.sh

#Create cluster.rc
cat << END > cluster.rc
begin
cluster_name=$HOST_NAME
cluster_codepath=$ISSM_DIR/bin
cluster_executionpath=$EXECUTION_PATH
end
END
source $ISSM_DIR/etc/environment.sh

#2: install some required external packages
cd $ISSM_DIR/externalpackages
for EP in $EP_LIST
do 
	cd $EP
	cp configs/$OS/* .
	./install.sh $NUMCPUS
	cd ..
done

#3: install automake and autoconf
cd $ISSM_DIR/devpackages
make
cd ..

#3: generate MakeFiles
sh scripts/automakererun.sh
sh config/$OS/$OS.sh

#4: compile and install ISSM
make  -j $NUMCPUS
make  -j $NUMCPUS install

#Launch matlab and the nightly run script
matlab -nojvm -nosplash  > ./nightlylong.log << EOF 
startup
nightlyrun($PACKAGES);
EOF

#removed unused lines to deal with a smaller file
cat nightlylong.log | egrep 'difference: |NIGHTLYRUNTERMINATEDCORRECTLY' > nightly.log
#rm nightlylong.log

#Build html report
sh cron/report.sh
		
#send mail
source cron/mailinglist
for i in `echo $MAILINGLIST`; do
cat - report.html <<HERE | /usr/lib/sendmail  -oi -t
From: "ISSM Nightly run" <$EMAIL_ADRESS>
To: $i
Subject: Nightly runs of $ISSM_RELEASE on: $host_name. Date:$today.
Mime-Version: 1.0
Content-Type: text/html
HERE
done

#Erase log and error logs
#rm -rf nightly.log report.html

#Erase ice code
#cd ..
#rm -rf trunk/
