#!/bin/bash
set -eu

#Some cleanup
rm -rf install petsc-2.3.2-p3 src
mkdir install src

#Download from ISSM server
$ISSM_DIR/scripts/DownloadExternalPackage.py 'http://issm.jpl.nasa.gov/files/externalpackages/petsc-2.3.2-p3.tar.gz' 'petsc-2.3.2-p3.tar.gz'

#Untar and move petsc to install directory
tar -zxvf  petsc-2.3.2-p3.tar.gz
mv petsc-2.3.2-p3/* install/
rm -rf petsc-2.3.2-p3

#configure
cd install
./config/configure.py  \
	--prefix="$ISSM_DIR/externalpackages/petsc/install" \
	--with-mpi-dir=$ISSM_DIR/externalpackages/mpich/install \
	--PETSC_ARCH=linux-gnu-amd64 \
	--PETSC_DIR="$ISSM_DIR/externalpackages/petsc/install" \
	--with-fc=gfortran \
	--with-debugging=1 \
	--with-shared=0 \
	--download-mumps=yes \
	--download-scalapack=yes \
	--download-blacs=yes \
	--download-blas=yes \
	--download-f-blas-lapack=yes \
	--FFLAGS=-I$ISSM_DIR/externalpackages/mpich/install/include \
	--download-plapack=yes \
	--COPTFLAGS="-march=opteron -O2" \
	--FOPTFLAGS="-march=opteron -O2" \
	--CXXOPTFLAGS="-march=opteron -O2" 

#Compile petsc and install it
make
make install
