#!/bin/sh

#External packages versions:
#petsc 3.3
#mpich 1.4

./configure \
 --prefix=$ISSM_DIR \
 --with-matlab-dir=$MATLAB_DIR \
 --with-triangle-dir=$ISSM_DIR/externalpackages/triangle/install \
 --with-metis-dir=$ISSM_DIR/externalpackages/petsc/src/externalpackages/metis-5.0.2-p3 \
 --with-petsc-dir=$ISSM_DIR/externalpackages/petsc/install \
 --with-tao-dir=$ISSM_DIR/externalpackages/tao/install \
 --with-mpi-include=$ISSM_DIR/externalpackages/mpich2/install/include  \
 --with-mpi-libflags="-L$ISSM_DIR/externalpackages/mpich2/install/lib/ -lmpich -lmpl " \
 --with-petsc-arch=$ISSM_ARCH \
 --with-gsl-dir=$ISSM_DIR/externalpackages/gsl/install \
 --with-dakota-dir=$ISSM_DIR/externalpackages/dakota/install \
 --with-blas-lapack-dir=$ISSM_DIR/externalpackages/petsc/install \
 --with-plapack-lib="-L$ISSM_DIR/externalpackages/petsc/install/ -lPLAPACK" \
 --with-plapack-include="-I$ISSM_DIR/externalpackages/petsc/install/externalpackages/PLAPACKR32-hg/INCLUDE" \
 --with-blacs-dir=$ISSM_DIR/externalpackages/petsc/install/ \
 --with-scalapack-dir=$ISSM_DIR/externalpackages/petsc/install/ \
 --with-mumps-dir=$ISSM_DIR/externalpackages/petsc/install/ \
 --with-scotch-dir="$ISSM_DIR/externalpackages/scotch/install" \
 --with-chaco-dir="$ISSM_DIR/externalpackages/chaco/install" \
 --with-shapelib-dir="$ISSM_DIR/externalpackages/shapelib/install" \
 --with-fortran-lib="-L/usr/lib/gcc/x86_64-redhat-linux/4.1.1/ -lgfortran" \
 --with-graphics-lib=/usr/lib64/libX11.so \
 --with-cxxoptflags="-march=opteron -O2" \
 --with-numthreads=16 \
 --enable-debugging
 #--with-serial=no \
