#!/bin/sh

#External packages versions:
#petsc 3.4
#mpich 3.0

./configure \
 --prefix=$ISSM_DIR \
 --with-matlab-dir=$ISSM_DIR/externalpackages/matlab/install \
 --with-triangle-dir=$ISSM_DIR/externalpackages/triangle/install \
 --with-metis-dir=$ISSM_DIR/externalpackages/petsc/install \
 --with-petsc-dir=$ISSM_DIR/externalpackages/petsc/install \
 --with-python-dir=$ISSM_DIR/externalpackages/python/install\
 --with-python-numpy-dir=$ISSM_DIR/externalpackages/python/install/lib/python2.7/site-packages/numpy/core/include/numpy\
 --with-dakota-dir=$ISSM_DIR/externalpackages/dakota/install \
 --with-boost-dir=$ISSM_DIR/externalpackages/boost/install/ \
 --with-tao-dir=$ISSM_DIR/externalpackages/tao/install \
 --with-mpi-include=$ISSM_DIR/externalpackages/mpich/install/include  \
 --with-mpi-lib="-L$ISSM_DIR/externalpackages/mpich/install/lib/ -lmpich -lmpl " \
 --with-petsc-arch=$ISSM_ARCH \
 --with-gsl-dir=$ISSM_DIR/externalpackages/gsl/install \
 --with-blas-lapack-dir=$ISSM_DIR/externalpackages/petsc/install \
 --with-scalapack-dir=$ISSM_DIR/externalpackages/petsc/install/ \
 --with-mumps-dir=$ISSM_DIR/externalpackages/petsc/install/ \
 --with-scotch-dir="$ISSM_DIR/externalpackages/scotch/install" \
 --with-chaco-dir="$ISSM_DIR/externalpackages/chaco/install" \
 --with-shapelib-dir="$ISSM_DIR/externalpackages/shapelib/install" \
 --with-fortran-lib="-L/usr/lib/gcc/x86_64-linux-gnu/4.6/ -lgfortran" \
 --with-graphics-lib="/usr/lib/x86_64-linux-gnu/libX11.so" \
 --with-cxxoptflags="-march=opteron -O2" \
 --with-numthreads=16 \
 --enable-debugging
