package gov.nasa.jpl.issm;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Log;

public class ImageList 
{
	private static ArrayList <Bitmap> imageList;
	private static ArrayList <Bitmap> imageListFromURL;
	private Context context;
	final int nImage = 17; 
//----------------------------------------------------------	
	public ImageList(Context context)
	{
		imageList = new ArrayList <Bitmap>();
		imageListFromURL = new ArrayList <Bitmap>();
		this.context = context;
	}
//----------------------------------------------------------
	public void decodeAndResizeImageFromURL()
	{
		URL url;
		for(int i =0; i <1; i++)
		{
			try 
			{
				url = new URL(ImageListFromUrl.imageUrls[0]);
				URLConnection connection = url.openConnection();
				HttpURLConnection httpConnection = (HttpURLConnection) connection;
	            httpConnection.setRequestMethod("GET");
	            httpConnection.connect();
	 
	            if (httpConnection.getResponseCode() == HttpURLConnection.HTTP_OK) 
	            {
	            	imageList.add(ImageResizer.decodeSampledBitmapFromURL(url, 50, 50)); 
	            }
		    } catch (IOException e) {
		        Log.e("ImageResizer", "Could not load Bitmap from: " + ImageListFromUrl.imageUrls[i]);
		    }
		}
	}
//----------------------------------------------------------
	public void decodeAndResizeImage()
	{
		int resID;
		for(int i = 1 ; i < nImage; i++)
		{
			resID=context.getResources().getIdentifier("image"+i, "drawable", context.getPackageName());
			imageList.add(ImageResizer.decodeSampledBitmapFromResource(context.getResources(), resID , 50, 50));
		}
	}
//----------------------------------------------------------
	public static ArrayList<Bitmap> getImageList()
	{
		return imageList;
	}
//----------------------------------------------------------
		public static ArrayList<Bitmap> getImageListFromURL()
		{
			return imageListFromURL;
		}	
}
