package gov.nasa.jpl.issm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import android.app.Activity;
import android.app.ProgressDialog;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Environment;
import android.util.Log;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Toast;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
/////////////////////////////////////////////////////////////////////////// 
public class ISSMAPP extends Activity
{
	ImageList imageList;
	private static final String PREFERENCE_FIRST_RUN = null;
	public static String extStorageDirectory;
	private String issmFolder; 
	SharedPreferences settings;
	private ProgressDialog progressDialog;
//------------------------------------------------------------------------	
	public void onCreate(Bundle icicle)
	{
		super.onCreate(icicle);
		setContentView(R.layout.splashscreen);		
	    settings = this.getSharedPreferences("MenuPage", 0);
	    boolean firstrun = settings.getBoolean(PREFERENCE_FIRST_RUN, true);
	    extStorageDirectory = Environment.getExternalStorageDirectory().toString();
	    issmFolder = extStorageDirectory + "/ISSM/input_files/";
	    imageList = new ImageList(this);
	    new CopyDataTask().execute(firstrun);    
	}
//-------------------------------------------------------------------------------------------
	//Start the splashscreen at beginning while transferring 
	//data file from Assets folder to SDcard
	private class CopyDataTask extends AsyncTask<Boolean,Void,Boolean>
	   {
			@Override
			protected Boolean doInBackground(Boolean... target) 
			{
				imageList.decodeAndResizeImageFromURL();
				imageList.decodeAndResizeImage();
				//not sure why, but target[0] can be true on install! more to be done.
				//if(target[0] = false)
				//{
			        SharedPreferences.Editor e = settings.edit();
			        e.putBoolean(PREFERENCE_FIRST_RUN, false);
			        
			        e.commit();
			        // If not, run these methods:
			        SetDirectory(issmFolder);
				//}
				return true;
			}
			@Override
			protected void onPreExecute()
			{
				progressDialog = new ProgressDialog(ISSMAPP.this);
				progressDialog.setMessage("Loading Data");
				progressDialog.setIndeterminate(true);
				progressDialog.setCancelable(false);
				progressDialog.show();
			}
			protected void onPostExecute(Boolean result)
			{
				progressDialog.dismiss();
				Intent i = new Intent(ISSMAPP.this, MenuPage.class);
				i.putExtra("pathToFile", issmFolder);
		        startActivity(i);
			}
	   }
//-------------------------------------------------------------------------------------------
	private void SetDirectory(String directory) 
	{
	    if (android.os.Environment.getExternalStorageState().equals(android.os.Environment.MEDIA_MOUNTED)) 
	    {
	        File txtDirectory = new File(issmFolder);
	        
	        // Check and create directory in SDcard
	        if(!txtDirectory.exists())
	        {
	        	txtDirectory.mkdirs();
	        }
	        CopyAssets(); // Then run the method to copy the file.

	    } 
	    else if (android.os.Environment.getExternalStorageState().equals(android.os.Environment.MEDIA_MOUNTED_READ_ONLY)) 
	    {
	    	Toast toast = Toast.makeText(this.getApplicationContext(), "Memory is not mounted to device", Toast.LENGTH_LONG);
	    	toast.show();
	    }

	}
//----------------------------------------------------------------------------
	/**
	 * -- Copy the file from the assets folder to the sdCard
	 * ===========================================================
	 **/
		private void CopyAssets() 
		{
		    AssetManager assetManager = getAssets();
		    String[] files = null;
		    try {
		        files = assetManager.list("Map");
		    } catch (IOException e) {
		        Log.e("tag", e.getMessage());
		    }
		    for (int i = 0; i < files.length; i++) {
		        InputStream in = null;
		        OutputStream out = null;
		        try {
		            in = assetManager.open("Map/"+files[i]);
		            out = new FileOutputStream(issmFolder + files[i]);
		            copyFile(in, out);
		            in.close();
		            in = null;
		            out.flush();
		            out.close();
		            out = null;
		        } catch (Exception e) {
		            Log.e("tag", e.getMessage());
		        }
		    }
		}
//----------------------------------------------------------------------------
		private void copyFile(InputStream in, OutputStream out) throws IOException 
		{
		    byte[] buffer = new byte[1024];
		    int read;
		    while ((read = in.read(buffer)) != -1) {
		        out.write(buffer, 0, read);
		    }
		}
//----------------------------------------------------------------------------
		 private void StartAnimations() 
		 {
		        Animation anim = AnimationUtils.loadAnimation(this, R.anim.alpha);
		        anim.reset();
		        LinearLayout l=(LinearLayout) findViewById(R.id.lin_lay);
		        l.clearAnimation();
		        l.startAnimation(anim);
		 
		        anim = AnimationUtils.loadAnimation(this, R.anim.translate);
		        anim.reset();
		        ImageView iv = (ImageView) findViewById(R.id.logo);
		        iv.clearAnimation();
		        iv.startAnimation(anim);
		    }
//-------------------------------------------------------------------------------		 
}
////////////////////////////////////////////////////////////////////////////////// 
