/*!\file MatlabMatrixToMatrix.cpp
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./matlabio.h"

Matrix<double>* MatlabMatrixToMatrix(const mxArray* mxmatrix){

	int dummy;
	Matrix<double>* matrix=NULL;

	/*allocate matrix object: */
	matrix=new Matrix<double>();

	#ifdef _HAVE_PETSC_
	matrix->pmatrix=MatlabMatrixToPetscMat(mxmatrix);
	#else
	matrix->imatrix=MatlabMatrixToIssmMat(mxmatrix);
	#endif

	return matrix;
}
