#!/bin/bash
#This bash script calls the nightlyrun.m matlab file to run our nightly test decks. 
#It then processes the results and sends an email to the Ice developpers.

#get configs
CONFIG_FILE="configs/`hostname -s`_config"
if [ -f $CONFIG_FILE ];
then
	echo "File $CONFIG_FILE not found. exiting..." 
	exit
else
	source $CONFIG_FILE
fi

#create nightly run variables
export today=`date | awk '{printf("%s-%s-%s",$2,$3,$6);}'`;
export host_name=`hostname`;

#create ISSM variables
export ISSM_DIR
export ISSM_ARCH
export ISSM_RELEASE

#Erase previous code and Fetch the new one
rm -rf trunk
svn checkout http://s383-rhat/issm/svn/issm/trunk

#install ISSM
cd $ISSM_DIR

#1: modify some variables
cd etc
	#modify MATLAB_PATH ( /usr/...   ->   \/usr\/...)
	echo $MATLAB_PATH | sed 's/\//\\\//g' > MATLAB_PATH2
	MATLAB_PATH2=`cat MATLAB_PATH2`
	rm MATLAB_PATH2

	#modify MATLAB_DIR in environment_variables.sh
	cat environment_variables.sh | sed -e "s/C:\/MATLAB\/R2009a\//$MATLAB_PATH2/g" > environment_variables.sh.bak
	mv environment_variables.sh.bak environment_variables.sh

	#modify EXECUTION_PATH ( /usr/...   ->   \/usr\/...)
	echo $EXECUTION_PATH | sed 's/\//\\\//g' | sed 's/-/\\-/g' > EXECUTION_PATH2
	EXECUTION_PATH2=`cat EXECUTION_PATH2`
	rm EXECUTION_PATH2
	echo $ISSM_DIR\/bin | sed 's/\//\\\//g' | sed 's/-/\\-/g' > CLUSTER_PATH
	CLUSTER_PATH=`cat CLUSTER_PATH`
	rm CLUSTER_PATH

	#modify EXECUTION_PATH in cluster.rc
	cat cluster.rc | sed -e "s-cluster_codepath.*-cluster_codepath\=$CLUSTER_PATH-" | sed -e "s-cluster_executionpath.*-cluster_executionpath\=$EXECUTION_PATH2-" > cluster.bak
	mv cluster.bak cluster.rc
cd ..
source $ISSM_DIR/etc/environment.sh

#2: install some required external packages
cd externalpackages
	cd mpich2
	cp configs/$EP_CONFIG/* .
	./install.sh $NUMCPUS
cd ../petsc
	cp configs/$EP_CONFIG/* .
	./install.sh $NUMCPUS
cd ../metis
	cp configs/$EP_CONFIG/* .
	./install.sh $NUMCPUS
cd ../triangle
	cp configs/$EP_CONFIG/* .
	./install.sh $NUMCPUS
cd $ISSM_DIR

#3: install automake and autoconf
cd devpackages
make
cd ..

#3: generate MakeFiles
sh scripts/automakererun.sh
sh config/wilkes/linux64.sh

#4: compile and install ISSM
if [ -z $NUMCPUS ];
then
	make
	make install
else
	make  -j $NUMCPUS
	make  -j $NUMCPUS install
fi

#Launch matlab and the nightly run script
matlab -nojvm -nosplash  > ./nightlylong.log << EOF 
startup
nightlyrun($PACKAGES);
EOF

#removed unused lines to deal with a smaller file
cat nightlylong.log | egrep 'difference: |NIGHTLYRUNTERMINATEDCORRECTLY' > nightly.log
#rm nightlylong.log

#Build html report
sh cron/report.sh
		
#send mail
source cron/mailinglist
for i in `echo $MAILINGLIST`; do
cat - report.html <<HERE | /usr/lib/sendmail  -oi -t
From: "ISSM Nightly run" <mathieu.morlighem@jpl.nasa.gov>
To: $i
Subject: Nightly runs of $ISSM_RELEASE on: $host_name. Date:$today.
Mime-Version: 1.0
Content-Type: text/html
HERE
done

#Erase log and error logs
#rm -rf nightly.log report.html

#Erase ice code
#cd ..
#rm -rf trunk/
