% This file can be run to update the velocity archives  of the test1.
% This test deals with an icesheet with icefront for a 3d model. The geometry 
% is square. Just run this file in Matlab, with a properly setup Ice code. 

% The archive files will be saved in this directory but will not commited to ice1. 
% Just commit the result if you want to.

%packages and solutions to be tested
packages={'macayeal','ice','cielo_serial','cielo_parallel'};
solutions={'diagnostic','thermal_steady','thermal_transient','prognostic','transient'};

%go through the solutions requested
testname='IceSheetIceFrontM3d_8';
for i=1:length(packages),
	package=packages{i};

	for j=1:length(solutions),
		solution=solutions{j};

		%check package
		if ~(strcmpi(package,'macayeal') | strcmpi(package,'ice') | strcmpi(package,'cielo_serial') | strcmpi(package,'cielo_parallel'));
			error(['package: ' package  ' in test: ' testname  ' not supported yet']);
			%check solution
		elseif ~(strcmpi(solution,'diagnostic') | strcmpi(solution,'thermal_steady') | strcmpi(solution,'thermal_transient') |...
				strcmpi(solution,'prognostic') | strcmpi(solution,'transient'));
			error(['solution: ' solution  ' in test: ' testname  ' not supported yet']);
		end
		%check solution requested
		if (~strcmpi(package,'ice')),
			disp(sprintf(['\nsolution: ' solution  ', with package: ' package  ', in test: ' testname  ', not supported yet.\n']));
			continue
		end

		%initialize model
		md=model;
		md=mesh(md,'DomainOutline.exp',50000);
		md=geography(md,'','');
		md=parameterize(md,'Square.par');
		md=extrude(md,10,3);
		md=setelementstype(md,'macayeal','all');
		if strcmpi(package,'cielo_parallel'), md.cluster='wilkes'; end
		if md.numberofgrids==3880
			load Velocities; md.vx=1.2*vx; md.vy=1.2*vy;
		end

		%compute solution
		if strcmpi(package,'cielo_parallel') & strcmpi(solution,'diagnostic'),
			md=solve(md,'diagnostic_horiz','cielo');
		elseif strcmpi(package,'cielo_serial'),
			eval(['md=solve(md,''' solution ''',''cielo'');']);
		else
			eval(['md=solve(md,''' solution ''',''' package ''');']);
		end

		%compute field to be checked
		if strcmpi(solution,'diagnostic'),
			fields={'vy','vz'};
		elseif strcmpi(solution,'thermal_steady'),
			fields={'temperature','melting'};
		elseif strcmpi(solution,'thermal_transient'),
			fields={'thermaltransient_results(end).temperature','thermaltransient_results(end).melting'};
		elseif strcmpi(solution,'prognostic'),
			fields={'new_thickness'};
		elseif strcmpi(solution,'transient'),
			fields={'transient_results(end).vy','transient_results(end).vz','transient_results(end).temperature','transient_results(end).melting','transient_results(end).thickness'};
		end

		%save new archive
		for k=1:length(fields),
			field=fields{k};
			eval(['Archive' package solution '_field' num2str(k) '=md.' field  ';']);
		end
		eval(['save Archive' package solution ' Archive' package solution '_field*']);
	end
end
