#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=$1;

#version of qhull
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/qhull-//g'`

#Some cleanup
rm -rf src install qhull-$version

#Create src and install directories
mkdir src install

#Untar 
tar -zxvf  qhull-$version.tar.gz

#Move qhull to src directory
rm -rf src/*
mv qhull-$version/* src/
rm -rf qhull-$version

#Configure qhull
cd src

./configure --prefix="$ISSM_DIR/externalpackages/qhull/install"

#Compile qhull and install it
if [ -z $NUMCPUS ];
then
	  make
	  make install
else
	  make  -j $NUMCPUS
	  make  -j $NUMCPUS install
fi
