function plot_googlemaps(md,data,options,plotlines,plotcols,i)
%PLOT_GOOGLEMAPS - superimpose Google maps to a given field
%
%   Usage:
%      plot_googlemaps(md,data,options,plotlines,plotcols,i)
%
%   See also: PLOTMODEL

%process mesh and data
[x y z elements is2d isplanet]=processmesh(md,[],options);
[data datatype]=processdata(md,data,options);

%check is2d
if ~is2d, 
	error('buildgridded error message: gridded not supported for 3d meshes, project on a layer');
end

if ~any(isnan(md.radaroverlay.x)) & ~any(isnan(md.radaroverlay.y)) & ~any(isnan(md.radaroverlay.pwr)) &...
		size(md.radaroverlay.pwr,3)==3 & all(size(md.radaroverlay.x)==size(md.radaroverlay.pwr)),
	disp('plot_googlemaps info: the RGB image held by the model is being used');
else
	disp('Extracting image from Google maps...');

	%Get xlim and ylim (used to extract radar image)
	xlim=getfieldvalue(options,'xlim',[min(x) max(x)]);
	ylim=getfieldvalue(options,'ylim',[min(y) max(y)]);
	[latlist lonlist]= xy2ll(...
		[linspace(xlim(1),xlim(2),100) linspace(xlim(2),xlim(2),100) linspace(xlim(2),xlim(1),100) linspace(xlim(1),xlim(1),100)],...
		[linspace(ylim(1),ylim(1),100) linspace(ylim(1),ylim(2),100) linspace(ylim(2),ylim(2),100) linspace(ylim(2),ylim(1),100)],...
		+1,45,70);

	%Image corners in lat/long
	ullat = max(latlist); ullon = min(lonlist);
	lrlat = min(latlist); lrlon = max(lonlist);

	md=googlemaps(md,ullat,ullon,lrlat,lrlon,options);
end

%Retrieve image from md
X = md.radaroverlay.x;
Y = md.radaroverlay.y;
final = md.radaroverlay.pwr;

%Get some options
transparency = getfieldvalue(options,'transparency',.3);

%Prepare grid
data_grid=InterpFromMeshToMesh2d(md.mesh.elements,md.mesh.x,md.mesh.y,data,X(:),Y(:),'default',NaN); data_grid=reshape(data_grid,size(X));
data_nan=isnan(data_grid);
if exist(options,'caxis'),
	caxis_opt=getfieldvalue(options,'caxis');
	data_grid(find(data_grid<caxis_opt(1)))=caxis_opt(1);
	data_grid(find(data_grid>caxis_opt(2)))=caxis_opt(2);
	data_min=caxis_opt(1);
	data_max=caxis_opt(2);
else
	data_min=min(data_grid(:));
	data_max=max(data_grid(:));
end
colorm = getcolormap(options);
image_rgb = ind2rgb(uint16((data_grid - data_min)*(length(colorm)/(data_max-data_min))),colorm);

alpha=ones(size(X));
alpha(find(~data_nan))=transparency;
alpha=repmat(alpha,[1 1 3]);

final=alpha.*final+(1-alpha).*image_rgb;

%Select plot area 
subplotmodel(plotlines,plotcols,i,options);

h=imagesc(X(1,:),Y(:,1),final);

%last step: mesh gridded?
if exist(options,'edgecolor'),
	A=elements(:,1); B=elements(:,2); C=elements(:,3); 
	patch('Faces',[A B C],'Vertices', [x y z],'FaceVertexCData',data_grid(1)*ones(size(x)),'FaceColor','none','EdgeColor',getfieldvalue(options,'edgecolor'));
end

%Apply options
if ~isnan(data_min),
	options=changefieldvalue(options,'caxis',[data_min data_max]); % force caxis so that the colorbar is ready
end
options=addfielddefault(options,'xlim',xlim);        % default xlim
options=addfielddefault(options,'ylim',ylim);        % default ylim
options=addfielddefault(options,'axis','xy equal off'); % default axis
applyoptions(md,data,options);
end
