from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class geometry(object):
	"""
	GEOMETRY class definition

	   Usage:
	      geometry=geometry();
	"""

	def __init__(self): # {{{
		self.surface           = float('NaN')
		self.thickness         = float('NaN')
		self.bed               = float('NaN')
		self.bathymetry        = float('NaN')
		self.hydrostatic_ratio = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{

		string="   geometry parameters:"
		string="%s\n%s"%(string,fielddisplay(self,'surface','surface elevation [m]'))
		string="%s\n%s"%(string,fielddisplay(self,'thickness','ice thickness [m]'))
		string="%s\n%s"%(string,fielddisplay(self,'bed','bed elevation [m]'))
		string="%s\n%s"%(string,fielddisplay(self,'bathymetry','bathymetry elevation [m]'))
		string="%s\n%s"%(string,fielddisplay(self,'hydrostatic_ratio','coefficient for ice shelves'' thickness correction: hydrostatic_ratio H_obs+ (1-hydrostatic_ratio) H_hydro'))
		return string
		#}}}
	def setdefaultparameters(self): # {{{
		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		md = checkfield(md,'geometry.surface'  ,'NaN',1,'size',[md.mesh.numberofvertices])
		md = checkfield(md,'geometry.bed'      ,'NaN',1,'size',[md.mesh.numberofvertices])
		md = checkfield(md,'geometry.thickness','NaN',1,'size',[md.mesh.numberofvertices],'>',0,'forcing',1)
		if any((self.thickness-self.surface+self.bed)>10**-9):
			md.checkmessage("equality thickness=surface-bed violated")
		if solution==TransientSolutionEnum() and md.transient.isgroundingline:
			md = checkfield(md,'geometry.bathymetry','NaN',1,'size',[md.mesh.numberofvertices])

		return md
	# }}}
	def marshall(self,md,fid):    # {{{
		WriteData(fid,'data',self.surface,'format','DoubleMat','mattype',1,'enum',SurfaceEnum())
		WriteData(fid,'data',self.thickness,'format','DoubleMat','mattype',1,'enum',ThicknessEnum(),'forcing',1)
		WriteData(fid,'data',self.bed,'format','DoubleMat','mattype',1,'enum',BedEnum())
		WriteData(fid,'data',self.bathymetry,'format','DoubleMat','mattype',1,'enum',BathymetryEnum())
		WriteData(fid,'object',self,'fieldname','hydrostatic_ratio','format','DoubleMat','mattype',1)
	# }}}
