%GEOMETRY class definition
%
%   Usage:
%      geometry=geometry();

classdef geometry
	properties (SetAccess=public) 
		surface           = NaN;
		thickness         = NaN;
		bed               = NaN;
		bathymetry        = NaN;
		hydrostatic_ratio = NaN;
	end
	methods
		function obj = geometry(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{

		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			if (solution==TransientSolutionEnum() & md.transient.isgia) | (solution==GiaSolutionEnum()),
				md = checkfield(md,'geometry.thickness','forcing',1,'NaN',1,'>=',0);
			else
				md = checkfield(md,'geometry.surface'  ,'NaN',1,'size',[md.mesh.numberofvertices 1]);
				md = checkfield(md,'geometry.bed'      ,'NaN',1,'size',[md.mesh.numberofvertices 1]);
				md = checkfield(md,'geometry.thickness','NaN',1,'size',[md.mesh.numberofvertices 1],'>',0);
				if any((obj.thickness-obj.surface+obj.bed)>10^-9),
					md = checkmessage(md,['equality thickness=surface-bed violated']);
				end 
				if solution==TransientSolutionEnum() & md.transient.isgroundingline,
					md = checkfield(md,'geometry.bathymetry','NaN',1,'size',[md.mesh.numberofvertices 1]);
				end
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   geometry parameters:'));

			fielddisplay(obj,'surface','surface elevation [m]');
			fielddisplay(obj,'thickness','ice thickness [m]');
			fielddisplay(obj,'bed','bed elevation [m]');
			fielddisplay(obj,'bathymetry','bathymetry elevation [m]');
			fielddisplay(obj,'hydrostatic_ratio','coefficient for ice shelves'' thickness correction: hydrostatic_ratio H_obs+ (1-hydrostatic_ratio) H_hydro');

		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'data',obj.surface,'format','DoubleMat','mattype',1,'enum',SurfaceEnum());
			WriteData(fid,'data',obj.thickness,'format','DoubleMat','mattype',1,'enum',ThicknessEnum(),'forcing',1);
			WriteData(fid,'data',obj.bed,'format','DoubleMat','mattype',1,'enum',BedEnum());
			WriteData(fid,'data',obj.bathymetry,'format','DoubleMat','mattype',1,'enum',BathymetryEnum());
			WriteData(fid,'object',obj,'fieldname','hydrostatic_ratio','format','DoubleMat','mattype',1);
		end % }}}
	end
end
