from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class hydrologyshreve(object):
	"""
	HYDROLOGYSHREVE class definition

	   Usage:
	      hydrologyshreve=hydrologyshreve();
	"""

	def __init__(self): # {{{
		self.spcwatercolumn = float('NaN')
		self.n              = 0
		self.CR             = 0
		self.p              = 0
		self.q              = 0
		self.kn             = 0
		self.stabilization  = 0

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		
		string='   hydrologyshreve solution parameters:'
		string="%s\n%s"%(string,fielddisplay(self,'spcwatercolumn','water thickness constraints (NaN means no constraint) [m]'))
		string="%s\n%s"%(string,fielddisplay(self,'n','Manning roughness coefficient'))
		string="%s\n%s"%(string,fielddisplay(self,'CR','tortuosity parameter'))
		string="%s\n%s"%(string,fielddisplay(self,'p','dimensionless exponent in Manning velocity formula'))
		string="%s\n%s"%(string,fielddisplay(self,'q','dimensionless exponent in Manning velocity formula'))
		string="%s\n%s"%(string,fielddisplay(self,'kn','parameter in effective pressure formula'))
		string="%s\n%s"%(string,fielddisplay(self,'stabilization','artificial diffusivity (default is 1). can be more than 1 to increase diffusivity.'))
		return string
		#}}}
	def setdefaultparameters(self): # {{{
		
		#Parameters from Johnson's 2002 thesis, section 3.5.4			 
		self.n=.02			
		self.CR=.01
		self.p=2
		self.q=1
		self.kn=0

		#Type of stabilization to use 0:nothing 1:artificial_diffusivity
		self.stabilization=1

		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		#Early return
		if HydrologyShreveAnalysisEnum() not in analyses:
			return md

		md = checkfield(md,'hydrology.spcwatercolumn','forcing',1)
		md = checkfield(md,'hydrology.stabilization','>=',0)

		return md
	# }}}
	def marshall(self,md,fid):    # {{{
		WriteData(fid,'enum',HydrologyModelEnum(),'data',HydrologyshreveEnum(),'format','Integer');
		WriteData(fid,'object',self,'fieldname','spcwatercolumn','format','DoubleMat','mattype',1)
		WriteData(fid,'object',self,'fieldname','n','format','Double')
		WriteData(fid,'object',self,'fieldname','CR','format','Double')
		WriteData(fid,'object',self,'fieldname','p','format','Double')
		WriteData(fid,'object',self,'fieldname','q','format','Double')
		WriteData(fid,'object',self,'fieldname','kn','format','Double')
		WriteData(fid,'object',self,'fieldname','stabilization','format','Double')
	# }}}
