from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class transient(object):
	"""
	TRANSIENT class definition

	   Usage:
	      transient=transient();
	"""

	def __init__(self): # {{{
		self.isprognostic      = False
		self.isdiagnostic      = False
		self.isthermal         = False
		self.isgroundingline   = False
		self.isgia             = False
		self.requested_outputs = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string='   transient solution parameters:'
		string="%s\n%s"%(string,fielddisplay(self,'isprognostic','indicates if a prognostic solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'isdiagnostic','indicates if a diagnostic solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'isthermal','indicates if a thermal solution is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'isgroundingline','indicates if a groundingline migration is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'isgia','indicates if a postglacial rebound is used in the transient'))
		string="%s\n%s"%(string,fielddisplay(self,'requested_outputs','list of additional outputs requested'))
		return string
		#}}}
	def setdefaultparameters(self): # {{{
		
		#full analysis: Diagnostic, Prognostic and Thermal but no groundingline migration for now
		self.isprognostic=True
		self.isdiagnostic=True
		self.isthermal=True
		self.isgroundingline=False
		self.isgia=False

		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		#Early return
		if not solution==TransientSolutionEnum():
			return md

		md = checkfield(md,'transient.isprognostic','numel',[1],'values',[0,1])
		md = checkfield(md,'transient.isdiagnostic','numel',[1],'values',[0,1])
		md = checkfield(md,'transient.isthermal','numel',[1],'values',[0,1])
		md = checkfield(md,'transient.isgroundingline','numel',[1],'values',[0,1])
		md = checkfield(md,'transient.isgia','numel',[1],'values',[0,1])
		md = checkfield(md,'transient.requested_outputs','size',[float('NaN')])


		return md
	# }}}
	def marshall(self,md,fid):    # {{{
		WriteData(fid,'object',self,'fieldname','isprognostic','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isdiagnostic','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isthermal','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isgroundingline','format','Boolean')
		WriteData(fid,'object',self,'fieldname','isgia','format','Boolean')
		WriteData(fid,'object',self,'fieldname','requested_outputs','format','DoubleMat','mattype',3)
	# }}}

