%STEADYSTATE class definition
%
%   Usage:
%      steadystate=steadystate();

classdef steadystate
	properties (SetAccess=public) 
		reltol            = 0;
		maxiter           = 0;
		requested_outputs = NaN;
	end
	methods
		function obj = steadystate(varargin) % {{{
			switch nargin
				case 0
					obj=setdefaultparameters(obj);
				otherwise
					error('constructor not supported');
			end
		end % }}}
		function obj = setdefaultparameters(obj) % {{{
			%maximum of steady state iterations
			obj.maxiter=100;

			%Relative tolerance for the steadystate convertgence
			obj.reltol=0.01;
		end % }}}
		function md = checkconsistency(obj,md,solution,analyses) % {{{

			%Early return
			if solution~=SteadystateSolutionEnum(), return; end;

			if md.timestepping.time_step~=0,
				md = checkmessage(md,['for a steadystate computation, timestepping.time_step must be zero.']);
			end

			if isnan(md.diagnostic.reltol),
				md = checkmessage(md,['for a steadystate computation, diagnostic.reltol (relative convergence criterion) must be defined!']);
			end
		end % }}}
		function disp(obj) % {{{
			disp(sprintf('   steadystate solution parameters:'));

			fielddisplay(obj,'reltol','relative tolerance criterion');
			fielddisplay(obj,'maxiter','maximum number of iterations');
			fielddisplay(obj,'requested_outputs','additional requested outputs');

		end % }}}
		function marshall(obj,md,fid) % {{{
			WriteData(fid,'object',obj,'fieldname','reltol','format','Double');
			WriteData(fid,'object',obj,'fieldname','maxiter','format','Integer');
			WriteData(fid,'object',obj,'fieldname','requested_outputs','format','DoubleMat','mattype',3);
		end % }}}
	end
end
