from fielddisplay import fielddisplay
from EnumDefinitions import *
from checkfield import *
from WriteData import *

class basalforcings(object):
	"""
	BASAL FORCINGS class definition

	   Usage:
	      basalforcings=basalforcings();
	"""

	def __init__(self): # {{{
		self.melting_rate             = float('NaN')
		self.melting_rate_correction  = float('NaN')
		self.geothermalflux           = float('NaN')

		#set defaults
		self.setdefaultparameters()

		#}}}
	def __repr__(self): # {{{
		string="   basal forcings parameters:"

		string="%s\n%s"%(string,fielddisplay(self,"melting_rate","basal melting rate (positive if melting) [m/yr]"))
		string="%s\n%s"%(string,fielddisplay(self,"melting_rate_correction","additional melting applied to compensate for dh/dt [m/yr]"))
		string="%s\n%s"%(string,fielddisplay(self,"geothermalflux","geothermal heat flux [W/m^2]"))
		return string
		#}}}
	def setdefaultparameters(self): # {{{
		return self
	#}}}
	def checkconsistency(self,md,solution,analyses):    # {{{

		if PrognosticAnalysisEnum() in analyses and not (solution==TransientSolutionEnum() and not md.transient.isprognostic):
			md = checkfield(md,'basalforcings.melting_rate','NaN',1,'forcing',1)

		if BalancethicknessAnalysisEnum() in analyses:
			md = checkfield(md,'basalforcings.melting_rate','NaN',1,'size',[md.mesh.numberofvertices])

		if ThermalAnalysisEnum() in analyses and not (solution==TransientSolutionEnum() and not md.transient.isthermal):
			md = checkfield(md,'basalforcings.melting_rate','NaN',1,'forcing',1)
			md = checkfield(md,'basalforcings.geothermalflux','NaN',1,'forcing',1,'>=',0)

		return md
	# }}}
	def marshall(self,fid):    # {{{

		yts=365.0*24.0*3600.0

		WriteData(fid,'object',self,'fieldname','melting_rate','format','DoubleMat','mattype',1,'scale',1./yts)
		WriteData(fid,'object',self,'fieldname','melting_rate_correction','format','DoubleMat','mattype',1,'scale',1./yts)
		WriteData(fid,'object',self,'fieldname','geothermalflux','format','DoubleMat','mattype',1)
	# }}}
