/*!\file StringArrayParam.c
 * \brief: implementation of the StringArrayParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"
/*}}}*/

/*StringArrayParam constructors and destructor*/
/*FUNCTION StringArrayParam::StringArrayParam(){{{*/
StringArrayParam::StringArrayParam(){
	return;
}
/*}}}*/
/*FUNCTION StringArrayParam::StringArrayParam(int enum_type,char** in_values,int in_numstrings){{{*/
StringArrayParam::StringArrayParam(int in_enum_type,char** in_values, int in_numstrings){

	int i;
	int size;

	enum_type=in_enum_type;
	numstrings=in_numstrings;

	if(numstrings){
		value=xNew<char*>(numstrings);
		for(i=0;i<numstrings;i++){
			char* string=NULL;
			size=strlen(in_values[i])+1;
			string=xNew<char>(size);
			xMemCpy<char>(string,in_values[i],size);
			value[i]=string;
		}
	}
	else value=NULL;

}
/*}}}*/
/*FUNCTION StringArrayParam::~StringArrayParam(){{{*/
StringArrayParam::~StringArrayParam(){

	int i;

	char* string=NULL;
	for(i=0;i<this->numstrings;i++){
		string=value[i];
		xDelete<char>(string);
	}
	xDelete<char*>(value);
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION StringArrayParam::Echo {{{*/
void StringArrayParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION StringArrayParam::DeepEcho{{{*/
void StringArrayParam::DeepEcho(void){

	int i;
	char* string=NULL;

	_printf_("StringArrayParam:\n");
	_printf_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")\n");
	for(i=0;i<this->numstrings;i++){
		string=this->value[i];
		_printf_("   " << i << ": " << string << "\n");
	}
}
/*}}}*/
/*FUNCTION StringArrayParam::Id{{{*/
int    StringArrayParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION StringArrayParam::ObjectEnum{{{*/
int StringArrayParam::ObjectEnum(void){

	return StringArrayParamEnum;

}
/*}}}*/
/*FUNCTION StringArrayParam::copy{{{*/
Object* StringArrayParam::copy() {

	return new StringArrayParam(this->enum_type,this->value,this->numstrings);

}
/*}}}*/

/*StringArrayParam virtual functions definitions: */
/*FUNCTION StringArrayParam::GetParameterValue{{{*/
void  StringArrayParam::GetParameterValue(char*** pstringarray,int* pM){

	int   i;
	char** outstrings=NULL;
	int   M;
	char* string=NULL;
	char* string2=NULL;
	int   stringsize;

	M=this->numstrings;
	if(this->numstrings){
		outstrings=xNew<char*>(this->numstrings);

		for(i=0;i<this->numstrings;i++){
			string=this->value[i];
			stringsize=strlen(string)+1;

			string2=xNew<char>(stringsize);
			xMemCpy<char>(string2,string,stringsize);

			outstrings[i]=string2;
		}
	}
	else outstrings=NULL;

	/*Assign output pointers:*/
	*pM=M;
	*pstringarray=outstrings;
}
/*}}}*/
/*FUNCTION StringArrayParam::GetParameterName{{{*/
void StringArrayParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION StringArrayParam::SetValue{{{*/
void  StringArrayParam::SetValue(char** stringarray,int M){

	int   i;
	char *string     = NULL;
	char *string2    = NULL;
	int   stringsize;

	/*first, avoid leak: */
	for(i=0;i<this->numstrings;i++){
		string=this->value[i];
		xDelete<char>(string);
	}
	xDelete<char*>(this->value);

	/*copy: */
	this->numstrings=M;
	this->value=xNew<char*>(this->numstrings);
	for(i=0;i<this->numstrings;i++){
		string=stringarray[i];
		stringsize=strlen(string)+1;

		string2=xNew<char>(stringsize);
		xMemCpy<char>(string2,string,stringsize);

		this->value[i]=string2;
	}
}
/*}}}*/
/*FUNCTION StringArrayParam::UnitConversion{{{*/
void  StringArrayParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
