/*!\file DataSetParam.c
 * \brief: implementation of the DataSetParam object
 */

/*header files: */
/*{{{*/
#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "shared/shared.h"
/*}}}*/

/*DataSetParam constructors and destructor*/
/*FUNCTION DataSetParam::DataSetParam(){{{*/
DataSetParam::DataSetParam(){
	value=NULL;
	return;
}
/*}}}*/
/*FUNCTION DataSetParam::DataSetParam(int enum_type,DataSet *value){{{*/
DataSetParam::DataSetParam(int in_enum_type,DataSet* in_value){

	enum_type=in_enum_type;
	value=in_value->Copy();;
}
/*}}}*/
/*FUNCTION DataSetParam::~DataSetParam(){{{*/
DataSetParam::~DataSetParam(){
	delete value;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION DataSetParam::Echo {{{*/
void DataSetParam::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION DataSetParam::DeepEcho{{{*/
void DataSetParam::DeepEcho(void){

	_printf_("DataSetParam:\n");
	_printf_("   enum:  " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")\n");
	this->value->Echo();
}
/*}}}*/
/*FUNCTION DataSetParam::Id{{{*/
int    DataSetParam::Id(void){ return -1; }
/*}}}*/
/*FUNCTION DataSetParam::ObjectEnum{{{*/
int DataSetParam::ObjectEnum(void){

	return DataSetParamEnum;

}
/*}}}*/
/*FUNCTION DataSetParam::copy{{{*/
Object* DataSetParam::copy() {

	return new DataSetParam(this->enum_type,this->value);

}
/*}}}*/

/*DataSetParam virtual functions definitions: */
/*FUNCTION DataSetParam::GetParameterName{{{*/
void DataSetParam::GetParameterName(char**pname){
	EnumToStringx(pname,this->enum_type);
}
/*}}}*/
/*FUNCTION DataSetParam::UnitConversion{{{*/
void  DataSetParam::UnitConversion(int direction_enum){
	/*do nothing, no unit conversion*/
}
/*}}}*/
/*FUNCTION DataSetParam::GetParameterValue{{{*/
void DataSetParam::GetParameterValue(DataSet** pdataset){
	*pdataset=value->Copy();
}
/*}}}*/
