/*!\file: thermal_core.cpp
 * \brief: core of the thermal solution 
 */ 

#include "./analyses.h"
#include "../toolkits/toolkits.h"
#include "../classes/classes.h"
#include "../shared/shared.h"
#include "../modules/modules.h"
#include "../solutionsequences/solutionsequences.h"

void thermal_core(FemModel* femmodel){

	/*intermediary*/
	bool   save_results;
	bool   dakota_analysis  = false;

	//first recover parameters common to all solutions
	femmodel->parameters->FindParam(&save_results,SaveResultsEnum);
	femmodel->parameters->FindParam(&dakota_analysis,QmuIsdakotaEnum);

	if(dakota_analysis){
		femmodel->SetCurrentConfiguration(ThermalAnalysisEnum);
		ResetConstraintsx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters);
	}

	if(VerboseSolution()) _printf0_("   computing temperatures\n");
	femmodel->SetCurrentConfiguration(ThermalAnalysisEnum);
	solutionsequence_thermal_nonlinear(femmodel);

	if(VerboseSolution()) _printf0_("   computing melting\n");
	femmodel->SetCurrentConfiguration(MeltingAnalysisEnum);
	solutionsequence_linear(femmodel);

	if(save_results){
		if(VerboseSolution()) _printf0_("   saving results\n");
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,TemperatureEnum);
		InputToResultx(femmodel->elements,femmodel->nodes,femmodel->vertices,femmodel->loads,femmodel->materials,femmodel->parameters,BasalforcingsMeltingRateEnum);
	}
}
