/*!\file Observation.c
 * \brief: implementation of the Observation object
 */

#include <stdlib.h>
#include "../classes.h"

/*Observation constructors and destructor*/
/*FUNCTION Observation::Observation(){{{*/
Observation::Observation(){
	return;
}
/*}}}*/
/*FUNCTION Observation::Observation(double x,double y,int xi,int yi,int index,double value){{{*/
Observation::Observation(double x_in,double y_in,int xi_in,int yi_in,int index_in,double value_in){

	this->x      = x_in;
	this->y      = y_in;
	this->xi     = xi_in;
	this->yi     = yi_in;
	this->index  = index_in;
	this->value  = value_in;
	this->weight = 1.;

}
/*}}}*/
/*FUNCTION Observation::~Observation(){{{*/
Observation::~Observation(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION Observation::Echo {{{*/
void Observation::Echo(void){

	_printf_("Observation" << "\n");
	_printf_("   index : " << this->index << "\n");
	_printf_("   x     : " << this->x << "\n");
	_printf_("   y     : " << this->y << "\n");
	_printf_("   xi    : " << "\n"); printbinary(this->xi); _printf_("\n");
	_printf_("   yi    : " << "\n"); printbinary(this->yi); _printf_("\n");
	_printf_("   weight: " << this->weight << "\n");
	_printf_("   value : " << this->value << "\n");
}
/*}}}*/

/*Observations functions*/
/*FUNCTION Observation::WriteXYObs(double* px,double* py,double* pobs){{{*/
void Observation::WriteXYObs(double* px,double* py,double* pobs){
	*px   = this->x;
	*py   = this->y;
	*pobs = this->value;
}
/*}}}*/
