/*!\file TriaP1ElementResult.c
 * \brief: implementation of the TriaP1ElementResult object
 */

#ifdef HAVE_CONFIG_H
	#include <config.h>
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "../classes.h"
#include "../../shared/shared.h"

/*TriaP1ElementResult constructors and destructor*/
/*FUNCTION TriaP1ElementResult::TriaP1ElementResult(){{{*/
TriaP1ElementResult::TriaP1ElementResult(){
	return;
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::TriaP1ElementResult(int in_enum_type,IssmDouble* in_values,int in_step, IssmDouble in_time){{{*/
TriaP1ElementResult::TriaP1ElementResult(int in_enum_type,IssmDouble* in_values,int in_step, IssmDouble in_time){

	enum_type=in_enum_type;
	values[0]=in_values[0];
	values[1]=in_values[1];
	values[2]=in_values[2];
	step=in_step;
	time=in_time;
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::~TriaP1ElementResult(){{{*/
TriaP1ElementResult::~TriaP1ElementResult(){
	return;
}
/*}}}*/

/*Object virtual functions definitions:*/
/*FUNCTION TriaP1ElementResult::Echo {{{*/
void TriaP1ElementResult::Echo(void){
	this->DeepEcho();
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::DeepEcho{{{*/
void TriaP1ElementResult::DeepEcho(void){

	_printf_("TriaP1ElementResult:" << "\n");
	_printf_("   enum: " << this->enum_type << " (" << EnumToStringx(this->enum_type) << ")" << "\n");
	_printf_("   values: [" << this->values[0] << " " << this->values[1] << " " << this->values[2] << "]" << "\n");
	_printf_("   step: " << this->step << "\n");
	_printf_("   time: " << this->time << "\n");
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::Id{{{*/
int    TriaP1ElementResult::Id(void){ return -1; }
/*}}}*/
/*FUNCTION TriaP1ElementResult::ObjectEnum{{{*/
int TriaP1ElementResult::ObjectEnum(void){

	return TriaP1ElementResultEnum;

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::copy{{{*/
Object* TriaP1ElementResult::copy() {

	return new TriaP1ElementResult(this->enum_type,this->values,this->step,this->time);

}
/*}}}*/

/*ElementResult management*/
/*FUNCTION TriaP1ElementResult::InstanceEnum{{{*/
int TriaP1ElementResult::InstanceEnum(void){

	return this->enum_type;

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::SpawnTriaElementResult{{{*/
ElementResult* TriaP1ElementResult::SpawnTriaElementResult(int* indices){

	/*output*/
	TriaP1ElementResult* outresult=NULL;

	/*Create new Tria result (copy of current result)*/
	outresult=new TriaP1ElementResult(this->enum_type,&this->values[0],this->step,this->time);

	/*Assign output*/
	return outresult;

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::ProcessUnits{{{*/
void TriaP1ElementResult::ProcessUnits(Parameters* parameters){

	UnitConversion(this->values,3,IuToExtEnum,this->enum_type);

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::NumberOfNodalValues{{{*/
int TriaP1ElementResult::NumberOfNodalValues(void){
	return 3;
}
/*}}}*/
/*FUNCTION TriaP1ElementResult::PatchFill{{{*/
void TriaP1ElementResult::PatchFill(int row, Patch* patch){

	 /*Here, we fill the result information into the patch object. First, let's remember what is in a row 
	  * of the patch object: enum_type step time element_id interpolation vertices_ids nodal_values
	  * Here, we will supply the enum_type, step, time, interpolation and nodal_values: */
	patch->fillresultinfo(row,this->enum_type,this->step,this->time,P1Enum,this->values,3);

}
/*}}}*/
/*FUNCTION TriaP1ElementResult::GetVectorFromResults{{{*/
void TriaP1ElementResult::GetVectorFromResults(Vector<IssmDouble>* vector,int* doflist,int* connectivitylist,int numdofs){

	IssmDouble data[3];

	if(numdofs!=3)_error_("Result " << EnumToStringx(this->enum_type) << " is a TriaP1ElementResult and cannot write vector of " << numdofs << " dofs");
	for(int i=0;i<3;i++) data[i]=this->values[i]/(IssmDouble)connectivitylist[i];
	vector->SetValues(numdofs,doflist,&data[0],ADD_VAL);

} /*}}}*/
/*FUNCTION TriaP1ElementResult::GetElementVectorFromResults{{{*/
void TriaP1ElementResult::GetElementVectorFromResults(Vector<IssmDouble>* vector,int dof){
	_error_("Result " << EnumToStringx(enum_type) << " is a TriaP1ElementResult and should not write vector of size numberofelemenrs");
} /*}}}*/
